/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.md5;

import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Jni;
import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Joints;
import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MD5Mesh {
    public String shader;
    public int numVertices;
    public int numWeights;
    public int numTriangles;
    public float[] vertices;
    public float[] weights;
    public short[] indices;
    public int floatsPerVertex;
    public int floatsPerWeight;
    static Vector3 bn = new Vector3();
    static Vector3 _A = new Vector3();
    static Vector3 _B = new Vector3();
    static Vector3 _n = new Vector3();
    static MD5Quaternion quat = new MD5Quaternion();
    static Vector3 vn = new Vector3();

    public float[] createVertexArray() {
        return this.createVertexArray(5);
    }

    public float[] createVertexArray(int stride) {
        float[] verts = new float[this.numVertices * stride];
        int vertex_stride = this.floatsPerVertex;
        int j = 0;
        for (int i = 0; i < this.vertices.length; i += vertex_stride) {
            j += 3;
            verts[j++] = this.vertices[i];
            verts[j++] = this.vertices[i + 1];
            if (stride != 8) continue;
            j += 3;
        }
        return verts;
    }

    public short[] getIndices() {
        return this.indices;
    }

    public void calculateVerticesN(MD5Joints skeleton, float[] verts, BoundingBox bbox) {
        MD5Mesh.calculateVerticesN(skeleton, this.weights, this.vertices, verts, this.floatsPerVertex, this.floatsPerWeight, bbox);
    }

    public void calculateVertices(MD5Joints skeleton, float[] verts, BoundingBox bbox) {
        MD5Mesh.calculateVertices(skeleton, this.weights, this.vertices, verts, this.floatsPerVertex, this.floatsPerWeight, bbox);
    }

    public static void calculateVerticesN(MD5Joints skeleton, float[] weights, float[] vertices, float[] verts, int vstride, int wstride, BoundingBox bbox) {
        int k = 0;
        for (int vertexOffset = 2; vertexOffset < vertices.length; vertexOffset += vstride) {
            float finalX = 0.0f;
            float finalY = 0.0f;
            float finalZ = 0.0f;
            int weightOffset = (int)vertices[vertexOffset];
            int weightCount = (int)vertices[vertexOffset + 1];
            weightOffset *= wstride;
            bn.set(vertices[vertexOffset + 2], vertices[vertexOffset + 3], vertices[vertexOffset + 4]);
            for (int j = 0; j < weightCount; ++j) {
                int jointOffset = (int)weights[weightOffset++] << 3;
                float bias = weights[weightOffset++];
                float vx = weights[weightOffset++];
                float vy = weights[weightOffset++];
                float vz = weights[weightOffset++];
                vn.set(weights[weightOffset++], weights[weightOffset++], weights[weightOffset++]);
                float qx = skeleton.joints[jointOffset + 4];
                float qy = skeleton.joints[jointOffset + 5];
                float qz = skeleton.joints[jointOffset + 6];
                float qw = skeleton.joints[jointOffset + 7];
                MD5Mesh.quat.x = qx;
                MD5Mesh.quat.y = qy;
                MD5Mesh.quat.z = qz;
                MD5Mesh.quat.w = qw;
                quat.rotate(vn);
                vn.mul(bias);
                bn.add(vn);
                float ix = -qx;
                float iy = -qy;
                float iz = -qz;
                float iw = qw;
                float tw = -qx * vx - qy * vy - qz * vz;
                float tx = qw * vx + qy * vz - qz * vy;
                float ty = qw * vy + qz * vx - qx * vz;
                float tz = qw * vz + qx * vy - qy * vx;
                vx = tx * iw + tw * ix + ty * iz - tz * iy;
                vy = ty * iw + tw * iy + tz * ix - tx * iz;
                vz = tz * iw + tw * iz + tx * iy - ty * ix;
                finalX += (skeleton.joints[jointOffset + 1] + vx) * bias;
                finalY += (skeleton.joints[jointOffset + 2] + vy) * bias;
                finalZ += (skeleton.joints[jointOffset + 3] + vz) * bias;
            }
            bbox.ext(finalX, finalY, finalZ);
            verts[k++] = finalX;
            verts[k++] = finalY;
            verts[k++] = finalZ;
            k += 2;
            bn.nor();
            verts[k++] = MD5Mesh.bn.x;
            verts[k++] = MD5Mesh.bn.y;
            verts[k++] = MD5Mesh.bn.z;
        }
    }

    public static void calculateVertices(MD5Joints skeleton, float[] weights, float[] vertices, float[] verts, int vstride, int wstride, BoundingBox bbox) {
        int k = 0;
        for (int vertexOffset = 2; vertexOffset < vertices.length; vertexOffset += vstride) {
            float finalX = 0.0f;
            float finalY = 0.0f;
            float finalZ = 0.0f;
            int weightOffset = (int)vertices[vertexOffset];
            int weightCount = (int)vertices[vertexOffset + 1];
            weightOffset = (weightOffset << 2) + weightOffset;
            for (int j = 0; j < weightCount; ++j) {
                int jointOffset = (int)weights[weightOffset++] << 3;
                float bias = weights[weightOffset++];
                float vx = weights[weightOffset++];
                float vy = weights[weightOffset++];
                float vz = weights[weightOffset++];
                float qx = skeleton.joints[jointOffset + 4];
                float qy = skeleton.joints[jointOffset + 5];
                float qz = skeleton.joints[jointOffset + 6];
                float qw = skeleton.joints[jointOffset + 7];
                float ix = -qx;
                float iy = -qy;
                float iz = -qz;
                float iw = qw;
                float tw = -qx * vx - qy * vy - qz * vz;
                float tx = qw * vx + qy * vz - qz * vy;
                float ty = qw * vy + qz * vx - qx * vz;
                float tz = qw * vz + qx * vy - qy * vx;
                vx = tx * iw + tw * ix + ty * iz - tz * iy;
                vy = ty * iw + tw * iy + tz * ix - tx * iz;
                vz = tz * iw + tw * iz + tx * iy - ty * ix;
                finalX += (skeleton.joints[jointOffset + 1] + vx) * bias;
                finalY += (skeleton.joints[jointOffset + 2] + vy) * bias;
                finalZ += (skeleton.joints[jointOffset + 3] + vz) * bias;
            }
            bbox.ext(finalX, finalY, finalZ);
            verts[k++] = finalX;
            verts[k++] = finalY;
            verts[k++] = finalZ;
            k += 2;
        }
    }

    public void calculateVerticesJni(MD5Joints skeleton, float[] verts) {
        MD5Jni.calculateVertices(skeleton.joints, this.weights, this.vertices, verts, this.numVertices);
    }

    public void calculateNormalsBind(MD5Joints bindPoseSkeleton, float[] verts) {
        MD5Mesh.calculateNormalsBind(bindPoseSkeleton, this.weights, this.vertices, this.indices, verts, this.floatsPerVertex, this.floatsPerWeight);
    }

    private static Vector3 calcNor(Vector3 v1, Vector3 v2, Vector3 v3) {
        _A = v2.cpy();
        _A.sub(v1);
        _B = v3.cpy();
        _B.sub(v2);
        _n = _A.crs(_B).nor();
        return _n;
    }

    public static void calculateNormalsBind(MD5Joints skeleton, float[] weights, float[] vertices, short[] indices, float[] verts, int vstride, int wstride) {
        short i1;
        int i;
        int vertexOffset;
        int k = 0;
        for (vertexOffset = 2; vertexOffset < vertices.length; vertexOffset += vstride) {
            float finalX = 0.0f;
            float finalY = 0.0f;
            float finalZ = 0.0f;
            int weightOffset = (int)vertices[vertexOffset];
            int weightCount = (int)vertices[vertexOffset + 1];
            weightOffset *= wstride;
            for (int j = 0; j < weightCount; ++j) {
                int jointOffset = (int)weights[weightOffset++] << 3;
                float bias = weights[weightOffset++];
                float vx = weights[weightOffset++];
                float vy = weights[weightOffset++];
                float vz = weights[weightOffset++];
                weightOffset += 3;
                float qx = skeleton.joints[jointOffset + 4];
                float qy = skeleton.joints[jointOffset + 5];
                float qz = skeleton.joints[jointOffset + 6];
                float qw = skeleton.joints[jointOffset + 7];
                float ix = -qx;
                float iy = -qy;
                float iz = -qz;
                float iw = qw;
                float tw = -qx * vx - qy * vy - qz * vz;
                float tx = qw * vx + qy * vz - qz * vy;
                float ty = qw * vy + qz * vx - qx * vz;
                float tz = qw * vz + qx * vy - qy * vx;
                vx = tx * iw + tw * ix + ty * iz - tz * iy;
                vy = ty * iw + tw * iy + tz * ix - tx * iz;
                vz = tz * iw + tw * iz + tx * iy - ty * ix;
                finalX += (skeleton.joints[jointOffset + 1] + vx) * bias;
                finalY += (skeleton.joints[jointOffset + 2] + vy) * bias;
                finalZ += (skeleton.joints[jointOffset + 3] + vz) * bias;
            }
            verts[k++] = finalX;
            verts[k++] = finalY;
            verts[k++] = finalZ;
            k += 2;
            k += 3;
        }
        for (i = 0; i < indices.length; i += 3) {
            i1 = indices[i];
            short i2 = indices[i + 1];
            short i3 = indices[i + 2];
            int vo1 = i1 * 8;
            int vo2 = i2 * 8;
            int vo3 = i3 * 8;
            Vector3 v1 = new Vector3(verts[vo1], verts[vo1 + 1], verts[vo1 + 2]);
            Vector3 v2 = new Vector3(verts[vo2], verts[vo2 + 1], verts[vo2 + 2]);
            Vector3 v3 = new Vector3(verts[vo3], verts[vo3 + 1], verts[vo3 + 2]);
            Vector3 fn = MD5Mesh.calcNor(v1, v2, v3);
            int ovo1 = i1 * 7;
            int ovo2 = i2 * 7;
            int ovo3 = i3 * 7;
            int n = ovo1 + 4;
            vertices[n] = vertices[n] + fn.x;
            int n2 = ovo1 + 5;
            vertices[n2] = vertices[n2] + fn.y;
            int n3 = ovo1 + 6;
            vertices[n3] = vertices[n3] + fn.z;
            int n4 = ovo2 + 4;
            vertices[n4] = vertices[n4] + fn.x;
            int n5 = ovo2 + 5;
            vertices[n5] = vertices[n5] + fn.y;
            int n6 = ovo2 + 6;
            vertices[n6] = vertices[n6] + fn.z;
            int n7 = ovo3 + 4;
            vertices[n7] = vertices[n7] + fn.x;
            int n8 = ovo3 + 5;
            vertices[n8] = vertices[n8] + fn.y;
            int n9 = ovo3 + 6;
            vertices[n9] = vertices[n9] + fn.z;
        }
        for (i = 0; i < indices.length; i += 3) {
            i1 = indices[i];
            short i2 = indices[i + 1];
            short i3 = indices[i + 2];
            int ovo1 = i1 * 7;
            int ovo2 = i2 * 7;
            int ovo3 = i3 * 7;
            vn.set(vertices[ovo1 + 4], vertices[ovo1 + 5], vertices[ovo1 + 6]);
            vn.nor();
            vertices[ovo1 + 4] = MD5Mesh.vn.x;
            vertices[ovo1 + 5] = MD5Mesh.vn.y;
            vertices[ovo1 + 6] = MD5Mesh.vn.z;
            vn.set(vertices[ovo2 + 4], vertices[ovo2 + 5], vertices[ovo2 + 6]);
            vn.nor();
            vertices[ovo2 + 4] = MD5Mesh.vn.x;
            vertices[ovo2 + 5] = MD5Mesh.vn.y;
            vertices[ovo2 + 6] = MD5Mesh.vn.z;
            vn.set(vertices[ovo3 + 4], vertices[ovo3 + 5], vertices[ovo3 + 6]);
            vn.nor();
            vertices[ovo3 + 4] = MD5Mesh.vn.x;
            vertices[ovo3 + 5] = MD5Mesh.vn.y;
            vertices[ovo3 + 6] = MD5Mesh.vn.z;
        }
        for (vertexOffset = 2; vertexOffset < vertices.length; vertexOffset += vstride) {
            int weightOffset = (int)vertices[vertexOffset];
            int weightCount = (int)vertices[vertexOffset + 1];
            weightOffset *= wstride;
            for (int j = 0; j < weightCount; ++j) {
                int jointOffset = (int)weights[weightOffset++] << 3;
                float qx = skeleton.joints[jointOffset + 4];
                float qy = skeleton.joints[jointOffset + 5];
                float qz = skeleton.joints[jointOffset + 6];
                float qw = skeleton.joints[jointOffset + 7];
                float vnx = vertices[vertexOffset + 2];
                float vny = vertices[vertexOffset + 3];
                float vnz = vertices[vertexOffset + 4];
                vn.set(vnx, vny, vnz);
                MD5Mesh.quat.x = qx;
                MD5Mesh.quat.y = qy;
                MD5Mesh.quat.z = qz;
                MD5Mesh.quat.w = qw;
                quat.invert();
                quat.rotate(vn);
                int n = weightOffset++;
                weights[n] = weights[n] + MD5Mesh.vn.x;
                int n10 = weightOffset++;
                weights[n10] = weights[n10] + MD5Mesh.vn.y;
                int n11 = weightOffset++;
                weights[n11] = weights[n11] + MD5Mesh.vn.z;
            }
        }
        for (i = 0; i < weights.length; i += wstride) {
            vn.set(weights[i + 5], weights[i + 6], weights[i + 7]);
            vn.nor();
            weights[i + 5] = MD5Mesh.vn.x;
            weights[i + 6] = MD5Mesh.vn.y;
            weights[i + 7] = MD5Mesh.vn.z;
        }
    }

    public void read(DataInputStream in) throws IOException {
        int i;
        this.shader = in.readUTF();
        this.numVertices = in.readInt();
        this.numWeights = in.readInt();
        this.numTriangles = in.readInt();
        this.floatsPerVertex = in.readInt();
        this.floatsPerWeight = in.readInt();
        this.vertices = new float[this.numVertices * this.floatsPerVertex];
        this.indices = new short[this.numTriangles * 3];
        this.weights = new float[this.numWeights * this.floatsPerWeight];
        for (i = 0; i < this.vertices.length; ++i) {
            this.vertices[i] = in.readFloat();
        }
        for (i = 0; i < this.indices.length; ++i) {
            this.indices[i] = in.readShort();
        }
        for (i = 0; i < this.weights.length; ++i) {
            this.weights[i] = in.readFloat();
        }
    }

    public void write(DataOutputStream out) throws IOException {
        int i;
        out.writeUTF(this.shader);
        out.writeInt(this.numVertices);
        out.writeInt(this.numWeights);
        out.writeInt(this.numTriangles);
        out.writeInt(this.floatsPerVertex);
        out.writeInt(this.floatsPerWeight);
        for (i = 0; i < this.vertices.length; ++i) {
            out.writeFloat(this.vertices[i]);
        }
        for (i = 0; i < this.indices.length; ++i) {
            out.writeShort(this.indices[i]);
        }
        for (i = 0; i < this.weights.length; ++i) {
            out.writeFloat(this.weights[i]);
        }
    }
}

