/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class NinePatch {
    public static final int TOP_LEFT = 0;
    public static final int TOP_CENTER = 1;
    public static final int TOP_RIGHT = 2;
    public static final int MIDDLE_LEFT = 3;
    public static final int MIDDLE_CENTER = 4;
    public static final int MIDDLE_RIGHT = 5;
    public static final int BOTTOM_LEFT = 6;
    public static final int BOTTOM_CENTER = 7;
    public static final int BOTTOM_RIGHT = 8;
    private TextureRegion[] patches;

    private NinePatch() {
    }

    public NinePatch(Texture texture, int left, int right, int top, int bottom) {
        this(new TextureRegion(texture), left, right, top, bottom);
    }

    public NinePatch(TextureRegion region, int left, int right, int top, int bottom) {
        int middleWidth = region.getRegionWidth() - left - right;
        int middleHeight = region.getRegionHeight() - top - bottom;
        this.patches = new TextureRegion[]{new TextureRegion(region, 0, 0, left, top), new TextureRegion(region, left, 0, middleWidth, top), new TextureRegion(region, left + middleWidth, 0, right, top), new TextureRegion(region, 0, top, left, middleHeight), new TextureRegion(region, left, top, middleWidth, middleHeight), new TextureRegion(region, left + middleWidth, top, right, middleHeight), new TextureRegion(region, 0, top + middleHeight, left, bottom), new TextureRegion(region, left, top + middleHeight, middleWidth, bottom), new TextureRegion(region, left + middleWidth, top + middleHeight, right, bottom)};
    }

    public NinePatch(TextureRegion region) {
        this.patches = new TextureRegion[]{null, null, null, null, region, null, null, null, null};
    }

    public NinePatch(TextureRegion ... patches) {
        if (patches.length != 9) {
            throw new IllegalArgumentException("NinePatch needs nine TextureRegions");
        }
        this.patches = patches;
        this.checkValidity();
    }

    private void checkValidity() {
        if (this.patches[6].getRegionWidth() != this.patches[0].getRegionWidth() || this.patches[6].getRegionWidth() != this.patches[3].getRegionWidth()) {
            throw new GdxRuntimeException("Left side patches must have the same width");
        }
        if (this.patches[8].getRegionWidth() != this.patches[2].getRegionWidth() || this.patches[8].getRegionWidth() != this.patches[5].getRegionWidth()) {
            throw new GdxRuntimeException("Right side patches must have the same width");
        }
        if (this.patches[6].getRegionHeight() != this.patches[7].getRegionHeight() || this.patches[6].getRegionHeight() != this.patches[8].getRegionHeight()) {
            throw new GdxRuntimeException("Bottom patches must have the same height");
        }
        if (this.patches[0].getRegionHeight() != this.patches[1].getRegionHeight() || this.patches[0].getRegionHeight() != this.patches[2].getRegionHeight()) {
            throw new GdxRuntimeException("Top patches must have the same height");
        }
    }

    public void draw(SpriteBatch batch, float x, float y, float width, float height) {
        float centerColumnX = x;
        if (this.patches[6] != null) {
            centerColumnX += (float)this.patches[6].getRegionWidth();
        } else if (this.patches[3] != null) {
            centerColumnX += (float)this.patches[3].getRegionWidth();
        } else if (this.patches[0] != null) {
            centerColumnX += (float)this.patches[0].getRegionWidth();
        }
        float rightColumnX = x + width;
        if (this.patches[8] != null) {
            rightColumnX -= (float)this.patches[8].getRegionWidth();
        } else if (this.patches[5] != null) {
            rightColumnX += (float)this.patches[5].getRegionWidth();
        } else if (this.patches[2] != null) {
            rightColumnX += (float)this.patches[2].getRegionWidth();
        }
        float middleRowY = y;
        if (this.patches[0] != null) {
            middleRowY += (float)this.patches[0].getRegionHeight();
        } else if (this.patches[1] != null) {
            middleRowY += (float)this.patches[1].getRegionHeight();
        } else if (this.patches[2] != null) {
            middleRowY += (float)this.patches[2].getRegionHeight();
        }
        float topRowY = y + height;
        if (this.patches[0] != null) {
            topRowY -= (float)this.patches[0].getRegionHeight();
        } else if (this.patches[1] != null) {
            topRowY -= (float)this.patches[1].getRegionHeight();
        } else if (this.patches[2] != null) {
            topRowY -= (float)this.patches[2].getRegionHeight();
        }
        if (this.patches[6] != null) {
            batch.draw(this.patches[6], x, y, centerColumnX - x, middleRowY - y);
        }
        if (this.patches[7] != null) {
            batch.draw(this.patches[7], centerColumnX, y, rightColumnX - centerColumnX, middleRowY - y);
        }
        if (this.patches[8] != null) {
            batch.draw(this.patches[8], rightColumnX, y, x + width - rightColumnX, middleRowY - y);
        }
        if (this.patches[3] != null) {
            batch.draw(this.patches[3], x, middleRowY, centerColumnX - x, topRowY - middleRowY);
        }
        if (this.patches[4] != null) {
            batch.draw(this.patches[4], centerColumnX, middleRowY, rightColumnX - centerColumnX, topRowY - middleRowY);
        }
        if (this.patches[5] != null) {
            batch.draw(this.patches[5], rightColumnX, middleRowY, x + width - rightColumnX, topRowY - middleRowY);
        }
        if (this.patches[0] != null) {
            batch.draw(this.patches[0], x, topRowY, centerColumnX - x, y + height - topRowY);
        }
        if (this.patches[1] != null) {
            batch.draw(this.patches[1], centerColumnX, topRowY, rightColumnX - centerColumnX, y + height - topRowY);
        }
        if (this.patches[2] != null) {
            batch.draw(this.patches[2], rightColumnX, topRowY, x + width - rightColumnX, y + height - topRowY);
        }
    }

    public float getLeftWidth() {
        return this.patches[0] == null ? 0.0f : (float)this.patches[0].getRegionWidth();
    }

    public float getRightWidth() {
        return this.patches[2] == null ? 0.0f : (float)this.patches[2].getRegionWidth();
    }

    public float getTopHeight() {
        return this.patches[2] == null ? 0.0f : (float)this.patches[2].getRegionHeight();
    }

    public float getBottomHeight() {
        return this.patches[8] == null ? 0.0f : (float)this.patches[8].getRegionHeight();
    }

    public float getTotalHeight() {
        float totalHeight = this.getTopHeight() + this.getBottomHeight();
        if (this.patches[4] != null) {
            totalHeight += (float)this.patches[4].getRegionHeight();
        }
        return totalHeight;
    }

    public float getTotalWidth() {
        float totalWidth = this.getLeftWidth() + this.getRightWidth();
        if (this.patches[4] != null) {
            totalWidth += (float)this.patches[4].getRegionWidth();
        }
        return totalWidth;
    }

    public TextureRegion[] getPatches() {
        return this.patches;
    }
}

