/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.NumberUtils;

public class BitmapFontCache
implements Disposable {
    private final BitmapFont font;
    private float[] vertices = new float[0];
    private int idx;
    private float x;
    private float y;
    private float color = Color.WHITE.toFloatBits();
    private final Color tmpColor = new Color(Color.WHITE);
    private final BitmapFont.TextBounds textBounds = new BitmapFont.TextBounds();
    private boolean integer = true;

    public BitmapFontCache(BitmapFont font) {
        this(font, true);
    }

    public BitmapFontCache(BitmapFont font, boolean integer) {
        this.font = font;
        this.integer = integer;
    }

    public void setPosition(float x, float y) {
        this.translate(x - this.x, y - this.y);
    }

    public void translate(float xAmount, float yAmount) {
        if (xAmount == 0.0f && yAmount == 0.0f) {
            return;
        }
        if (this.integer) {
            xAmount = (int)xAmount;
            yAmount = (int)yAmount;
        }
        this.x += xAmount;
        this.y += yAmount;
        float[] vertices = this.vertices;
        int n = this.idx;
        for (int i = 0; i < n; i += 5) {
            int n2 = i;
            vertices[n2] = vertices[n2] + xAmount;
            int n3 = i + 1;
            vertices[n3] = vertices[n3] + yAmount;
        }
    }

    public void setColor(float color) {
        if (color == this.color) {
            return;
        }
        this.color = color;
        float[] vertices = this.vertices;
        int n = this.idx;
        for (int i = 2; i < n; i += 5) {
            vertices[i] = color;
        }
    }

    public void setColor(Color tint) {
        float color = tint.toFloatBits();
        if (color == this.color) {
            return;
        }
        this.color = color;
        float[] vertices = this.vertices;
        int n = this.idx;
        for (int i = 2; i < n; i += 5) {
            vertices[i] = color;
        }
    }

    public void setColor(float r, float g, float b, float a) {
        int intBits = (int)(255.0f * a) << 24 | (int)(255.0f * b) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r);
        float color = NumberUtils.intBitsToFloat(intBits & 0xFEFFFFFF);
        if (color == this.color) {
            return;
        }
        this.color = color;
        float[] vertices = this.vertices;
        int n = this.idx;
        for (int i = 2; i < n; i += 5) {
            vertices[i] = color;
        }
    }

    public void draw(SpriteBatch spriteBatch) {
        spriteBatch.draw(this.font.getRegion().getTexture(), this.vertices, 0, this.idx);
    }

    public void draw(SpriteBatch spriteBatch, float alphaModulation) {
        Color color = this.getColor();
        float oldAlpha = color.a;
        color.a *= alphaModulation;
        this.setColor(color);
        this.draw(spriteBatch);
        color.a = oldAlpha;
        this.setColor(color);
    }

    public Color getColor() {
        float floatBits = this.color;
        int intBits = NumberUtils.floatToRawIntBits(this.color);
        Color color = this.tmpColor;
        color.r = (float)(intBits & 0xFF) / 255.0f;
        color.g = (float)(intBits >>> 8 & 0xFF) / 255.0f;
        color.b = (float)(intBits >>> 16 & 0xFF) / 255.0f;
        color.a = (float)(intBits >>> 24 & 0xFF) / 255.0f;
        return color;
    }

    private void reset(int glyphCount) {
        this.x = 0.0f;
        this.y = 0.0f;
        this.idx = 0;
        int vertexCount = glyphCount * 20;
        if (this.vertices == null || this.vertices.length < vertexCount) {
            this.vertices = new float[vertexCount];
        }
    }

    private float addToCache(CharSequence str, float x, float y, int start, int end) {
        float startX = x;
        BitmapFont font = this.font;
        BitmapFont.Glyph lastGlyph = null;
        if (font.data.scaleX == 1.0f && font.data.scaleY == 1.0f) {
            while (start < end) {
                if ((lastGlyph = font.data.getGlyph(str.charAt(start++))) == null) continue;
                this.addGlyph(lastGlyph, x + (float)lastGlyph.xoffset, y + (float)lastGlyph.yoffset, lastGlyph.width, lastGlyph.height);
                x += (float)lastGlyph.xadvance;
                break;
            }
            while (start < end) {
                char ch;
                BitmapFont.Glyph g;
                if ((g = font.data.getGlyph(ch = str.charAt(start++))) == null) continue;
                lastGlyph = g;
                this.addGlyph(lastGlyph, (x += (float)lastGlyph.getKerning(ch)) + (float)g.xoffset, y + (float)g.yoffset, g.width, g.height);
                x += (float)g.xadvance;
            }
        } else {
            float scaleX = font.data.scaleX;
            float scaleY = font.data.scaleY;
            while (start < end) {
                if ((lastGlyph = font.data.getGlyph(str.charAt(start++))) == null) continue;
                this.addGlyph(lastGlyph, x + (float)lastGlyph.xoffset * scaleX, y + (float)lastGlyph.yoffset * scaleY, (float)lastGlyph.width * scaleX, (float)lastGlyph.height * scaleY);
                x += (float)lastGlyph.xadvance * scaleX;
                break;
            }
            while (start < end) {
                char ch;
                BitmapFont.Glyph g;
                if ((g = font.data.getGlyph(ch = str.charAt(start++))) == null) continue;
                lastGlyph = g;
                this.addGlyph(lastGlyph, (x += (float)lastGlyph.getKerning(ch) * scaleX) + (float)g.xoffset * scaleX, y + (float)g.yoffset * scaleY, (float)g.width * scaleX, (float)g.height * scaleY);
                x += (float)g.xadvance * scaleX;
            }
        }
        return x - startX;
    }

    private void addGlyph(BitmapFont.Glyph glyph, float x, float y, float width, float height) {
        float x2 = x + width;
        float y2 = y + height;
        float u = glyph.u;
        float u2 = glyph.u2;
        float v = glyph.v;
        float v2 = glyph.v2;
        float[] vertices = this.vertices;
        if (this.integer) {
            x = (int)x;
            y = (int)y;
            x2 = (int)x2;
            y2 = (int)y2;
        }
        vertices[this.idx++] = x;
        vertices[this.idx++] = y;
        vertices[this.idx++] = this.color;
        vertices[this.idx++] = u;
        vertices[this.idx++] = v;
        vertices[this.idx++] = x;
        vertices[this.idx++] = y2;
        vertices[this.idx++] = this.color;
        vertices[this.idx++] = u;
        vertices[this.idx++] = v2;
        vertices[this.idx++] = x2;
        vertices[this.idx++] = y2;
        vertices[this.idx++] = this.color;
        vertices[this.idx++] = u2;
        vertices[this.idx++] = v2;
        vertices[this.idx++] = x2;
        vertices[this.idx++] = y;
        vertices[this.idx++] = this.color;
        vertices[this.idx++] = u2;
        vertices[this.idx++] = v;
    }

    public BitmapFont.TextBounds setText(CharSequence str, float x, float y) {
        return this.setText(str, x, y, 0, str.length());
    }

    public BitmapFont.TextBounds setText(CharSequence str, float x, float y, int start, int end) {
        this.reset(end - start);
        this.textBounds.width = this.addToCache(str, x, y += this.font.data.ascent, start, end);
        this.textBounds.height = this.font.data.capHeight;
        return this.textBounds;
    }

    public BitmapFont.TextBounds setMultiLineText(CharSequence str, float x, float y) {
        return this.setMultiLineText(str, x, y, 0.0f, BitmapFont.HAlignment.LEFT);
    }

    public BitmapFont.TextBounds setMultiLineText(CharSequence str, float x, float y, float alignmentWidth, BitmapFont.HAlignment alignment) {
        BitmapFont font = this.font;
        int length = str.length();
        this.reset(length);
        float down = font.data.down;
        float maxWidth = 0.0f;
        float startY = y += font.data.ascent;
        int start = 0;
        int numLines = 0;
        while (start < length) {
            float lineWidth;
            int lineEnd = BitmapFont.indexOf(str, '\n', start);
            float xOffset = 0.0f;
            if (alignment != BitmapFont.HAlignment.LEFT) {
                lineWidth = font.getBounds((CharSequence)str, (int)start, (int)lineEnd).width;
                xOffset = alignmentWidth - lineWidth;
                if (alignment == BitmapFont.HAlignment.CENTER) {
                    xOffset /= 2.0f;
                }
            }
            lineWidth = this.addToCache(str, x + xOffset, y, start, lineEnd);
            maxWidth = Math.max(maxWidth, lineWidth);
            start = lineEnd + 1;
            y += down;
            ++numLines;
        }
        this.textBounds.width = maxWidth;
        this.textBounds.height = font.data.capHeight + (float)(numLines - 1) * font.data.lineHeight;
        return this.textBounds;
    }

    public BitmapFont.TextBounds setWrappedText(CharSequence str, float x, float y, float wrapWidth) {
        return this.setWrappedText(str, x, y, wrapWidth, BitmapFont.HAlignment.LEFT);
    }

    public BitmapFont.TextBounds setWrappedText(CharSequence str, float x, float y, float wrapWidth, BitmapFont.HAlignment alignment) {
        BitmapFont font = this.font;
        int length = str.length();
        this.reset(length);
        y += font.data.ascent;
        float down = font.data.down;
        float maxWidth = 0.0f;
        int start = 0;
        int numLines = 0;
        while (start < length) {
            float lineWidth;
            int lineEnd = start + font.computeVisibleGlyphs(str, start, BitmapFont.indexOf(str, '\n', start), wrapWidth);
            if (lineEnd < length) {
                char ch;
                while (lineEnd > start && (ch = str.charAt(lineEnd)) != ' ' && ch != '\n') {
                    --lineEnd;
                }
            }
            if (lineEnd == start) {
                ++lineEnd;
            }
            float xOffset = 0.0f;
            if (alignment != BitmapFont.HAlignment.LEFT) {
                lineWidth = font.getBounds((CharSequence)str, (int)start, (int)lineEnd).width;
                xOffset = wrapWidth - lineWidth;
                if (alignment == BitmapFont.HAlignment.CENTER) {
                    xOffset /= 2.0f;
                }
            }
            lineWidth = this.addToCache(str, x + xOffset, y, start, lineEnd);
            maxWidth = Math.max(maxWidth, lineWidth);
            start = lineEnd + 1;
            y += down;
            ++numLines;
        }
        this.textBounds.width = maxWidth;
        this.textBounds.height = font.data.capHeight + (float)(numLines - 1) * font.data.lineHeight;
        return this.textBounds;
    }

    public BitmapFont.TextBounds getBounds() {
        return this.textBounds;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public BitmapFont getFont() {
        return this.font;
    }

    @Override
    public void dispose() {
        this.font.dispose();
    }

    public void setUseIntegerPositions(boolean use) {
        this.integer = use;
    }

    public boolean usesIntegerPositions() {
        return this.integer;
    }
}

