/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureRef;
import com.badlogic.gdx.utils.ObjectMap;

public class TextureDict {
    private static ObjectMap<String, TextureRef> sDictionary = new ObjectMap();

    public static TextureRef loadTexture(String path) {
        return TextureDict.loadTexture(path, Texture.TextureFilter.MipMap, Texture.TextureFilter.Linear, Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
    }

    public static TextureRef loadTexture(String path, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, Texture.TextureWrap uwrap, Texture.TextureWrap vwrap) {
        if (sDictionary.containsKey(path)) {
            TextureRef ref = sDictionary.get(path);
            ref.addRef();
            return ref;
        }
        FileHandle texFile = Gdx.app.getFiles().getFileHandle(path, Files.FileType.Internal);
        Texture newTex = new Texture(texFile, minFilter.isMipMap() || magFilter.isMipMap());
        newTex.setFilter(minFilter, magFilter);
        newTex.setWrap(uwrap, vwrap);
        TextureRef ref = new TextureRef(path, newTex);
        sDictionary.put(path, ref);
        return ref;
    }

    public static void removeTexture(String path) {
        sDictionary.remove(path);
    }

    public static void unloadAll() {
        for (TextureRef tex : sDictionary.values()) {
            tex.dispose();
        }
        sDictionary.clear();
    }
}

