/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.audio.io;

import com.badlogic.gdx.audio.io.Decoder;
import java.nio.ShortBuffer;

public class VorbisDecoder
implements Decoder {
    private final long handle;

    public VorbisDecoder(String filename) {
        this.handle = this.openFile(filename);
        if (this.handle == 0L) {
            throw new IllegalArgumentException("couldn't open file '" + filename + "'");
        }
    }

    @Override
    public void dispose() {
        this.closeFile(this.handle);
    }

    @Override
    public float getLength() {
        return this.getLength(this.handle);
    }

    @Override
    public int getNumChannels() {
        return this.getNumChannels(this.handle);
    }

    @Override
    public int getRate() {
        return this.getRate(this.handle);
    }

    @Override
    public int readSamples(ShortBuffer samples) {
        int read = this.readSamples(this.handle, samples, samples.capacity());
        samples.position(0);
        return read;
    }

    @Override
    public int skipSamples(int numSamples) {
        return this.skipSamples(this.handle, numSamples);
    }

    private native long openFile(String var1);

    private native int getNumChannels(long var1);

    private native int getRate(long var1);

    private native float getLength(long var1);

    private native int readSamples(long var1, ShortBuffer var3, int var4);

    private native int skipSamples(long var1, int var3);

    private native void closeFile(long var1);
}

