/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.audio.analysis;

import java.util.ArrayList;
import java.util.List;

public class ThresholdFunction {
    private final int historySize;
    private final float multiplier;

    public ThresholdFunction(int historySize, float multiplier) {
        this.historySize = historySize;
        this.multiplier = multiplier;
    }

    public List<Float> calculate(List<Float> spectralFlux) {
        ArrayList<Float> thresholds = new ArrayList<Float>(spectralFlux.size());
        for (int i = 0; i < spectralFlux.size(); ++i) {
            float sum = 0.0f;
            int start = Math.max(0, i - this.historySize / 2);
            int end = Math.min(spectralFlux.size() - 1, i + this.historySize / 2);
            for (int j = start; j <= end; ++j) {
                sum += spectralFlux.get(j).floatValue();
            }
            sum /= (float)(end - start);
            thresholds.add(Float.valueOf(sum *= this.multiplier));
        }
        return thresholds;
    }
}

