/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.ETC1TextureData;
import com.badlogic.gdx.graphics.glutils.FileTextureData;
import com.badlogic.gdx.utils.Array;

public class TextureLoader
extends AsynchronousAssetLoader<Texture, TextureParameter> {
    TextureData data;
    Texture texture;

    public TextureLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, TextureParameter parameter) {
        if (parameter == null || parameter != null && parameter.textureData == null) {
            Pixmap pixmap = null;
            Pixmap.Format format = null;
            boolean genMipMaps = false;
            this.texture = null;
            if (parameter != null) {
                format = parameter.format;
                genMipMaps = parameter.genMipMaps;
                this.texture = parameter.texture;
            }
            FileHandle handle = this.resolve(fileName);
            if (!fileName.contains(".etc1")) {
                pixmap = new Pixmap(handle);
                this.data = new FileTextureData(handle, pixmap, format, genMipMaps);
            } else {
                this.data = new ETC1TextureData(handle, genMipMaps);
            }
        } else {
            this.data = parameter.textureData;
            this.texture = parameter.texture;
        }
    }

    @Override
    public Texture loadSync(AssetManager manager, String fileName, TextureParameter parameter) {
        if (this.texture != null) {
            this.texture.load(this.data);
            return this.texture;
        }
        return new Texture(this.data);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, TextureParameter parameter) {
        return null;
    }

    public static class TextureParameter
    extends AssetLoaderParameters<Texture> {
        public Pixmap.Format format = null;
        public boolean genMipMaps = false;
        public Texture texture = null;
        public TextureData textureData = null;
    }
}

