/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.ObjectMap;

public class SkinLoader
extends AsynchronousAssetLoader<Skin, SkinParameter> {
    private FileHandle skinFile;
    private ObjectMap<String, String> fontPaths;

    public SkinLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, SkinParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Missing SkinParameter: " + fileName);
        }
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>();
        deps.add(new AssetDescriptor<Texture>(parameter.texturePath, Texture.class));
        ObjectMap root = (ObjectMap)new JsonReader().parse(this.resolve(fileName));
        ObjectMap resources = (ObjectMap)root.get("resources");
        ObjectMap bitmapFontMap = null;
        if (resources != null) {
            bitmapFontMap = (ObjectMap)resources.get(BitmapFont.class.getName());
        }
        this.fontPaths = new ObjectMap();
        if (bitmapFontMap != null) {
            this.skinFile = this.resolve(fileName);
            for (ObjectMap.Entry entry : bitmapFontMap.entries()) {
                FileHandle fontFile = this.skinFile.parent().child((String)entry.value);
                if (!fontFile.exists()) {
                    fontFile = Gdx.files.internal((String)entry.value);
                }
                AssetDescriptor<BitmapFont> asset = new AssetDescriptor<BitmapFont>(fontFile.path(), BitmapFont.class);
                this.fontPaths.put((String)entry.key, asset.fileName);
                deps.add(asset);
            }
        }
        return deps;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, SkinParameter parameter) {
    }

    @Override
    public Skin loadSync(AssetManager manager, String fileName, SkinParameter parameter) {
        Skin.SkinData data = new Skin.SkinData();
        data.texture = manager.get(parameter.texturePath, Texture.class);
        ObjectMap fonts = new ObjectMap();
        data.resources.put(BitmapFont.class, fonts);
        for (ObjectMap.Entry<String, String> entry : this.fontPaths.entries()) {
            fonts.put(entry.key, manager.get((String)entry.value, BitmapFont.class));
        }
        return new Skin(this.skinFile, data);
    }

    public static class SkinParameter
    extends AssetLoaderParameters<Skin> {
        public final String texturePath;

        public SkinParameter(String texturePath) {
            this.texturePath = texturePath;
        }
    }
}

