/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx;

import com.badlogic.gdx.InputProcessor;
import java.util.ArrayList;

public class InputMultiplexer
implements InputProcessor {
    private ArrayList<InputProcessor> processors = new ArrayList(4);

    public InputMultiplexer() {
    }

    public InputMultiplexer(InputProcessor ... processors) {
        for (int i = 0; i < processors.length; ++i) {
            this.processors.add(processors[i]);
        }
    }

    public void addProcessor(InputProcessor processor) {
        this.processors.add(processor);
    }

    public void removeProcessor(InputProcessor processor) {
        this.processors.remove(processor);
    }

    public void clear() {
        this.processors.clear();
    }

    @Override
    public boolean keyDown(int keycode) {
        int n = this.processors.size();
        for (int i = 0; i < n; ++i) {
            if (!this.processors.get(i).keyDown(keycode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        int n = this.processors.size();
        for (int i = 0; i < n; ++i) {
            if (!this.processors.get(i).keyUp(keycode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        int n = this.processors.size();
        for (int i = 0; i < n; ++i) {
            if (!this.processors.get(i).keyTyped(character)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean touchDown(int x, int y, int pointer, int button) {
        int n = this.processors.size();
        for (int i = 0; i < n; ++i) {
            if (!this.processors.get(i).touchDown(x, y, pointer, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean touchUp(int x, int y, int pointer, int button) {
        int n = this.processors.size();
        for (int i = 0; i < n; ++i) {
            if (!this.processors.get(i).touchUp(x, y, pointer, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean touchDragged(int x, int y, int pointer) {
        int n = this.processors.size();
        for (int i = 0; i < n; ++i) {
            if (!this.processors.get(i).touchDragged(x, y, pointer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean touchMoved(int x, int y) {
        int n = this.processors.size();
        for (int i = 0; i < n; ++i) {
            if (!this.processors.get(i).touchMoved(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        int n = this.processors.size();
        for (int i = 0; i < n; ++i) {
            if (!this.processors.get(i).scrolled(amount)) continue;
            return true;
        }
        return false;
    }
}

