/*
 * Decompiled with CFR 0.152.
 */
package com.bitbof.spinGame.worlds;

import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.bitbof.spinGame.Rythm;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Assets;
import com.bitbof.spinGame.assets.Texture;
import com.bitbof.spinGame.entities.Bond;
import com.bitbof.spinGame.entities.Camera;
import com.bitbof.spinGame.entities.Creature;
import com.bitbof.spinGame.entities.Entity;
import com.bitbof.spinGame.entities.Floor;
import com.bitbof.spinGame.entities.GameLogo;
import com.bitbof.spinGame.worlds.Levels;
import com.bitbof.spinGame.worlds.World;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class WorldOne
extends World {
    public int level = 0;
    public ArrayList<Entity> entities = new ArrayList();
    public Bond bond;
    public Rectangle goal;
    public Camera camera;
    public GameLogo logo;
    public int counter = 0;
    public boolean first = true;

    public WorldOne() {
        this.initLevel();
    }

    public void initLevel() {
        this.entities.clear();
        this.bond = new Bond(this);
        this.camera = new Camera(this);
        Levels.initLevel(this.level, this);
        if (this.first) {
            this.first = false;
            this.logo = new GameLogo();
            this.entities.add(this.logo);
            this.camera.doCrazyZoom();
        }
    }

    @Override
    public void update() {
        int i;
        if (!this.camera.isZooming()) {
            this.bond.update();
            if (this.bond.isDead()) {
                this.initLevel();
                return;
            }
            i = 0;
            while (i < this.bond.creatures.size() && !this.bond.locked) {
                Creature c = this.bond.creatures.get(i);
                if (Intersector.overlapCircleRectangle((Circle)new Circle(new Vector2(c.pos.x, c.pos.y), c.size.x / 2.0f), (Rectangle)this.goal)) {
                    ++this.level;
                    Assets.goal.play();
                    this.initLevel();
                    return;
                }
                ++i;
            }
            ++this.counter;
            this.camera.pos = new Vector2(this.bond.getCenter()).mul(0.1f).add(new Vector2(this.camera.pos).mul(0.9f));
        }
        this.camera.update();
        if (!this.camera.isZooming()) {
            i = 0;
            while (i < this.entities.size()) {
                Entity e = this.entities.get(i);
                e.update();
                if (e.isDead()) {
                    this.entities.remove(i--);
                }
                ++i;
            }
        }
    }

    @Override
    public void draw() {
        float rfac2;
        float rfac;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(512.0f - this.camera.pos.x * this.camera.zoom), (float)(384.0f - this.camera.pos.y * this.camera.zoom), (float)0.0f);
        GL11.glScalef((float)this.camera.zoom, (float)this.camera.zoom, (float)1.0f);
        int i = 0;
        while (i < 10) {
            rfac = (float)Math.sin((double)((Rythm.getBeat() + (float)(i * 4)) / 20.0f) * Math.PI * 0.5 + 0.5);
            rfac2 = (float)Math.sin((double)((Rythm.getBeat() + (float)(i * 4) + 2.0f) / 6.0f) * Math.PI * 0.5 + 0.5);
            GL11.glPushMatrix();
            Texture texture = Art.texture;
            texture.bind();
            GL11.glColor4f((float)(1.0f - rfac), (float)(1.0f - rfac2), (float)rfac, (float)(0.05f * (float)this.level / (float)Levels.levelCount));
            GL11.glTranslatef((float)this.camera.pos.x, (float)this.camera.pos.y, (float)0.0f);
            GL11.glScalef((float)(500.0f * rfac), (float)(500.0f * rfac), (float)1.0f);
            GL11.glRotatef((float)new Vector2(this.goal.x + this.goal.width / 2.0f, this.goal.y + this.goal.height / 2.0f).sub(this.camera.pos).angle(), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)0.0f, (float)texture.getHeight());
            GL11.glVertex2f((float)-0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)texture.getWidth(), (float)texture.getHeight());
            GL11.glVertex2f((float)0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)texture.getWidth(), (float)0.0f);
            GL11.glVertex2f((float)0.5f, (float)0.5f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)-0.5f, (float)0.5f);
            GL11.glEnd();
            GL11.glPopMatrix();
            ++i;
        }
        i = 0;
        while (i < 10) {
            rfac = (float)Math.sin((double)((Rythm.getBeat() + (float)(i * 4)) / 20.0f) * Math.PI * 0.5 + 0.5);
            rfac2 = (float)Math.sin((double)((Rythm.getBeat() + (float)(i * 4) + 2.0f) / 6.0f) * Math.PI * 0.5 + 0.5);
            float grow = (Rythm.getBeat() / 100.0f + (float)i / 10.0f) % 1.0f;
            GL11.glPushMatrix();
            Texture texture = Art.dirCircle;
            texture.bind();
            float alpha = (1.0f - Math.max(0.9f, grow)) * 10.0f;
            GL11.glColor4f((float)(1.0f - rfac), (float)(1.0f - rfac2), (float)rfac, (float)(alpha * 0.05f));
            GL11.glTranslatef((float)(this.goal.x + this.goal.width / 2.0f), (float)(this.goal.y + this.goal.height / 2.0f), (float)0.0f);
            GL11.glScalef((float)(1000.0f * grow), (float)(1000.0f * grow), (float)1.0f);
            GL11.glRotatef((float)new Vector2(this.goal.x + this.goal.width / 2.0f, this.goal.y + this.goal.height / 2.0f).sub(this.camera.pos).angle(), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)0.0f, (float)texture.getHeight());
            GL11.glVertex2f((float)-0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)texture.getWidth(), (float)texture.getHeight());
            GL11.glVertex2f((float)0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)texture.getWidth(), (float)0.0f);
            GL11.glVertex2f((float)0.5f, (float)0.5f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)-0.5f, (float)0.5f);
            GL11.glEnd();
            GL11.glPopMatrix();
            ++i;
        }
        i = 0;
        while (i < this.entities.size()) {
            Entity e = this.entities.get(i);
            e.draw();
            ++i;
        }
        this.bond.draw();
        if (this.level == 0) {
            GL11.glPushMatrix();
            Texture texture = Art.controls_move;
            texture.bind();
            GL11.glColor4f((float)(0.6f - 0.3f * (Rythm.getBeat() / 2.0f % 1.0f)), (float)(0.6f - 0.3f * (Rythm.getBeat() / 4.0f % 1.0f)), (float)0.6f, (float)1.0f);
            GL11.glTranslatef((float)14.0f, (float)-58.0f, (float)0.0f);
            GL11.glScalef((float)32.0f, (float)32.0f, (float)1.0f);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)0.0f, (float)texture.getHeight());
            GL11.glVertex2f((float)-0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)texture.getWidth(), (float)texture.getHeight());
            GL11.glVertex2f((float)0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)texture.getWidth(), (float)0.0f);
            GL11.glVertex2f((float)0.5f, (float)0.5f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)-0.5f, (float)0.5f);
            GL11.glEnd();
            GL11.glPopMatrix();
        }
        if (this.level == 2) {
            GL11.glPushMatrix();
            Texture texture = Art.controls_spin;
            texture.bind();
            GL11.glColor4f((float)(0.6f - 0.3f * (Rythm.getBeat() / 2.0f % 1.0f)), (float)(0.6f - 0.3f * (Rythm.getBeat() / 4.0f % 1.0f)), (float)0.6f, (float)1.0f);
            GL11.glTranslatef((float)210.0f, (float)-30.0f, (float)0.0f);
            GL11.glScalef((float)64.0f, (float)32.0f, (float)1.0f);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)0.0f, (float)texture.getHeight());
            GL11.glVertex2f((float)-0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)texture.getWidth(), (float)texture.getHeight());
            GL11.glVertex2f((float)0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)texture.getWidth(), (float)0.0f);
            GL11.glVertex2f((float)0.5f, (float)0.5f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)-0.5f, (float)0.5f);
            GL11.glEnd();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        if (this.level == 10) {
            GL11.glPushMatrix();
            Texture texture = Art.end;
            texture.bind();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)512.0f, (float)384.0f, (float)0.0f);
            GL11.glScalef((float)512.0f, (float)512.0f, (float)1.0f);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)0.0f, (float)texture.getHeight());
            GL11.glVertex2f((float)-0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)texture.getWidth(), (float)texture.getHeight());
            GL11.glVertex2f((float)0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)texture.getWidth(), (float)0.0f);
            GL11.glVertex2f((float)0.5f, (float)0.5f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)-0.5f, (float)0.5f);
            GL11.glEnd();
            GL11.glPopMatrix();
        }
    }

    @Override
    public ArrayList<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public void addBlock(float x, float y, float w, float h, int type) {
        if (type == World.B_START) {
            if (this.level == 0) {
                this.camera.pos.x = x * (float)World.BLOCKSIZE;
                this.camera.pos.y = y * (float)World.BLOCKSIZE;
            }
            Creature c = new Creature(this);
            c.pos.x = x * (float)World.BLOCKSIZE;
            c.pos.y = y * (float)World.BLOCKSIZE;
            this.entities.add(c);
            this.bond = new Bond(this);
            this.bond.add(c);
            this.bond.pos = new Vector2(x * (float)World.BLOCKSIZE, y * (float)World.BLOCKSIZE);
        } else if (type == World.B_CREATURE) {
            Creature c = new Creature(this);
            c.pos.x = x * (float)World.BLOCKSIZE;
            c.pos.y = y * (float)World.BLOCKSIZE;
            this.entities.add(c);
        } else if (type == World.B_FLOOR) {
            Floor c = new Floor(this);
            c.pos.x = x * (float)World.BLOCKSIZE;
            c.pos.y = y * (float)World.BLOCKSIZE;
            c.size.x = w * (float)World.BLOCKSIZE;
            c.size.y = h * (float)World.BLOCKSIZE;
            this.entities.add(c);
        } else if (type == World.B_GOAL) {
            this.goal = new Rectangle(x * (float)World.BLOCKSIZE - (float)World.BLOCKSIZE / 2.0f, y * (float)World.BLOCKSIZE - h * (float)World.BLOCKSIZE + (float)World.BLOCKSIZE / 2.0f, w * (float)World.BLOCKSIZE, h * (float)World.BLOCKSIZE);
        }
    }
}

