/*
 * Decompiled with CFR 0.152.
 */
package com.bitbof.spinGame.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.bitbof.spinGame.SpinGame;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Assets;
import com.bitbof.spinGame.assets.Texture;
import com.bitbof.spinGame.screens.Screen;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class TemplateScreen
extends Screen
implements InputProcessor {
    private float deltaCount = 0.0f;
    public boolean pause = false;

    public TemplateScreen(SpinGame templateGame) {
        super(templateGame);
        Gdx.input.setInputProcessor((InputProcessor)this);
        this.initGL();
        Assets.loadAssets();
    }

    public void initGL() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glMatrixMode((int)5889);
        GL11.glOrtho((double)0.0, (double)1024.0, (double)0.0, (double)768.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
    }

    @Override
    public void update(float deltaTime) {
        this.deltaCount += deltaTime;
        if ((double)this.deltaCount > 0.01) {
            this.deltaCount = 0.0f;
            this.logic();
        }
    }

    public void logic() {
    }

    @Override
    public void present(float deltaTime) {
        if (this.pause) {
            return;
        }
        GL11.glOrtho((double)0.0, (double)Display.getDisplayMode().getWidth(), (double)0.0, (double)Display.getDisplayMode().getHeight(), (double)-1.0, (double)1.0);
        GL11.glLoadIdentity();
        GL11.glClear((int)17408);
        GL11.glPushMatrix();
        Texture texture = Art.texture;
        texture.bind();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)512.0f, (float)384.0f, (float)0.0f);
        GL11.glScalef((float)1024.0f, (float)768.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)texture.getHeight());
        GL11.glVertex2f((float)-0.5f, (float)-0.5f);
        GL11.glTexCoord2f((float)texture.getWidth(), (float)texture.getHeight());
        GL11.glVertex2f((float)0.5f, (float)-0.5f);
        GL11.glTexCoord2f((float)texture.getWidth(), (float)0.0f);
        GL11.glVertex2f((float)0.5f, (float)0.5f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)-0.5f, (float)0.5f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    @Override
    public void pause() {
        this.pause = true;
    }

    @Override
    public void resume() {
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void dispose() {
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public boolean keyDown(int keycode) {
        Assets.sound.play();
        if (keycode == 131) {
            Gdx.app.exit();
        }
        return false;
    }

    public boolean keyUp(int keycode) {
        return false;
    }

    public boolean keyTyped(char character) {
        return false;
    }

    public boolean touchDown(int x, int y, int pointer, int button) {
        return false;
    }

    public boolean touchUp(int x, int y, int pointer, int button) {
        return false;
    }

    public boolean touchDragged(int x, int y, int pointer) {
        return false;
    }

    public boolean touchMoved(int x, int y) {
        return false;
    }

    public boolean scrolled(int amount) {
        return false;
    }
}

