/*
 * Decompiled with CFR 0.152.
 */
package com.bitbof.spinGame.entities;

import com.badlogic.gdx.math.Vector2;
import com.bitbof.spinGame.Rythm;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Assets;
import com.bitbof.spinGame.assets.Texture;
import com.bitbof.spinGame.entities.Entity;
import org.lwjgl.opengl.GL11;

public class GameLogo
extends Entity {
    public Vector2 pos = new Vector2(38.0f, 0.0f);
    public float scale = 10.0f;
    public float spacing = 5.0f;
    public long counter = 0L;
    public String text = "nano spin";
    public boolean first = true;
    public float motion_in = 100.0f;
    public float motion_pause = 50.0f;
    public float motion_out = 100.0f;

    @Override
    public void update() {
        ++this.counter;
        if (this.first) {
            this.first = false;
            Assets.music.play();
            Rythm.startTime = System.nanoTime();
        }
    }

    @Override
    public void draw() {
        int i = 0;
        while (i < this.text.length()) {
            GL11.glPushMatrix();
            Texture texture = this.getTex(this.text.charAt(i));
            if (texture != null) {
                Vector2 origin;
                float norm;
                texture.bind();
                Vector2 offset = new Vector2(this.pos.x + (float)i * (this.spacing + this.scale), this.pos.y);
                if ((float)this.counter < this.motion_in) {
                    norm = (float)this.counter / this.motion_in;
                    float easeOut = (float)Math.pow(norm - 1.0f, 4.0);
                    origin = new Vector2(0.0f, 0.0f);
                    GL11.glColor4f((float)(1.0f - 0.3f * (Rythm.getBeat() / 2.0f % 1.0f)), (float)(1.0f - 0.3f * (Rythm.getBeat() / 4.0f % 1.0f)), (float)1.0f, (float)norm);
                    GL11.glTranslatef((float)offset.x, (float)(offset.y + easeOut * 10.0f + 20.0f), (float)0.0f);
                    GL11.glRotatef((float)(easeOut * 180.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-20.0f, (float)0.0f);
                    GL11.glScalef((float)this.scale, (float)(this.scale * 2.0f), (float)1.0f);
                } else if ((float)this.counter < this.motion_pause + this.motion_in) {
                    GL11.glColor4f((float)(1.0f - 0.3f * (Rythm.getBeat() / 2.0f % 1.0f)), (float)(1.0f - 0.3f * (Rythm.getBeat() / 4.0f % 1.0f)), (float)1.0f, (float)1.0f);
                    GL11.glTranslatef((float)offset.x, (float)offset.y, (float)0.0f);
                    GL11.glScalef((float)this.scale, (float)(this.scale * 2.0f), (float)1.0f);
                } else if ((float)this.counter < this.motion_out + this.motion_pause + this.motion_in) {
                    norm = ((float)this.counter - this.motion_pause - this.motion_in) / this.motion_out;
                    float easeIn = (float)Math.pow(norm, 4.0);
                    origin = new Vector2(0.0f, 0.0f);
                    GL11.glColor4f((float)(1.0f - 0.3f * (Rythm.getBeat() / 2.0f % 1.0f)), (float)(1.0f - 0.3f * (Rythm.getBeat() / 4.0f % 1.0f)), (float)1.0f, (float)(1.0f - norm));
                    GL11.glTranslatef((float)offset.x, (float)(offset.y + easeIn * 10.0f - 20.0f), (float)0.0f);
                    GL11.glRotatef((float)(easeIn * 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)20.0f, (float)0.0f);
                    GL11.glScalef((float)this.scale, (float)(this.scale * 2.0f), (float)1.0f);
                } else {
                    GL11.glPopMatrix();
                    return;
                }
                GL11.glBegin((int)7);
                GL11.glTexCoord2f((float)0.0f, (float)texture.getHeight());
                GL11.glVertex2f((float)-0.5f, (float)-0.5f);
                GL11.glTexCoord2f((float)texture.getWidth(), (float)texture.getHeight());
                GL11.glVertex2f((float)0.5f, (float)-0.5f);
                GL11.glTexCoord2f((float)texture.getWidth(), (float)0.0f);
                GL11.glVertex2f((float)0.5f, (float)0.5f);
                GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                GL11.glVertex2f((float)-0.5f, (float)0.5f);
                GL11.glEnd();
                GL11.glPopMatrix();
            }
            ++i;
        }
    }

    public Texture getTex(char c) {
        if (c == 'n') {
            return Art.l_n;
        }
        if (c == 'a') {
            return Art.l_a;
        }
        if (c == 'o') {
            return Art.l_o;
        }
        if (c == 's') {
            return Art.l_s;
        }
        if (c == 'p') {
            return Art.l_p;
        }
        if (c == 'i') {
            return Art.l_i;
        }
        if (c == ' ') {
            return null;
        }
        System.out.println("FAILLL");
        return null;
    }

    @Override
    public Vector2 getPos() {
        return null;
    }

    @Override
    public boolean isDead() {
        return (float)this.counter > this.motion_in + this.motion_pause + this.motion_out;
    }
}

