/*
 * Decompiled with CFR 0.152.
 */
package com.bitbof.spinGame.entities;

import com.badlogic.gdx.math.Vector2;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Texture;
import com.bitbof.spinGame.entities.Entity;
import com.bitbof.spinGame.worlds.World;
import org.lwjgl.opengl.GL11;

public class DeathEffect
extends Entity {
    public Vector2 size;
    public Vector2 pos;
    public Vector2 v;
    public Vector2 a;
    public float height;
    public float radius;
    public boolean alive;
    public World world;
    public long counter = 0L;
    public float rand;

    public DeathEffect(World w) {
        this.world = w;
        this.size = new Vector2(10.0f, 10.0f);
        this.pos = new Vector2((float)Math.random() * 120.0f - 20.0f, (float)Math.random() * -120.0f + 20.0f);
        this.v = new Vector2(0.0f, 0.0f);
        this.a = new Vector2(0.0f, 0.0f);
        this.alive = true;
        this.radius = 5.0f;
        this.rand = (float)Math.random() * 2.0f - 1.0f;
    }

    @Override
    public void update() {
        ++this.counter;
        if (this.counter > 15L) {
            this.alive = false;
        }
    }

    @Override
    public void draw() {
        GL11.glPushMatrix();
        float facA = 0.0f;
        Texture texture = Art.deathA;
        texture.bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - (float)this.counter / 15.0f));
        GL11.glTranslatef((float)this.pos.x, (float)this.pos.y, (float)0.0f);
        GL11.glScalef((float)(this.size.x * (1.0f - facA * 0.3f)), (float)(this.size.y * (1.0f - facA * 0.3f)), (float)1.0f);
        GL11.glRotatef((float)(this.rand * 1000.0f + (float)Math.sin((double)((float)this.counter / 15.0f * 2.0f * -this.rand) * Math.PI)), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)texture.getHeight());
        GL11.glVertex2f((float)-0.5f, (float)-0.5f);
        GL11.glTexCoord2f((float)texture.getWidth(), (float)texture.getHeight());
        GL11.glVertex2f((float)0.5f, (float)-0.5f);
        GL11.glTexCoord2f((float)texture.getWidth(), (float)0.0f);
        GL11.glVertex2f((float)0.5f, (float)0.5f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)-0.5f, (float)0.5f);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        texture = Art.deathB;
        texture.bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - (float)this.counter / 15.0f));
        GL11.glTranslatef((float)((float)((double)this.pos.x + Math.sin((double)((float)this.counter / 14.0f * 2.0f) * Math.PI))), (float)this.pos.y, (float)0.0f);
        GL11.glScalef((float)(this.size.x * (1.0f - facA * 0.3f)), (float)(this.size.y * (1.0f - facA * 0.3f)), (float)1.0f);
        GL11.glRotatef((float)(this.rand * 1000.0f + (float)(-Math.sin((double)((float)this.counter / 14.0f * this.rand) * Math.PI))), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)texture.getHeight());
        GL11.glVertex2f((float)-0.5f, (float)-0.5f);
        GL11.glTexCoord2f((float)texture.getWidth(), (float)texture.getHeight());
        GL11.glVertex2f((float)0.5f, (float)-0.5f);
        GL11.glTexCoord2f((float)texture.getWidth(), (float)0.0f);
        GL11.glVertex2f((float)0.5f, (float)0.5f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)-0.5f, (float)0.5f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    @Override
    public Vector2 getPos() {
        return null;
    }

    @Override
    public boolean isDead() {
        return !this.alive;
    }
}

