/*
 * Decompiled with CFR 0.152.
 */
package com.bitbof.spinGame.entities;

import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.bitbof.spinGame.Rythm;
import com.bitbof.spinGame.assets.Art;
import com.bitbof.spinGame.assets.Texture;
import com.bitbof.spinGame.entities.Entity;
import com.bitbof.spinGame.entities.Floor;
import com.bitbof.spinGame.worlds.World;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class Creature
extends Entity {
    public Vector2 size;
    public Vector2 pos;
    public Vector2 v;
    public Vector2 a;
    public float height;
    public float radius;
    public boolean alive;
    public World world;
    public boolean bonded;
    public boolean locked;
    public long lockedCounter;
    public boolean touching = false;
    public float offset;

    public Creature(World w) {
        this.world = w;
        this.size = new Vector2(10.0f, 10.0f);
        this.pos = new Vector2((float)Math.random() * 120.0f - 20.0f, (float)Math.random() * -120.0f + 20.0f);
        this.v = new Vector2(0.0f, 0.0f);
        this.a = new Vector2(0.0f, 0.0f);
        this.alive = true;
        this.radius = 5.0f;
        this.bonded = false;
        this.touching = true;
        this.offset = (float)Math.random();
    }

    @Override
    public void update() {
        this.a = this.a.mul(0.6f);
        this.v = this.v.add(this.a).mul(0.95f);
        this.pos = this.pos.add(this.v);
        this.lockedCounter = this.locked ? ++this.lockedCounter : Math.max(0L, Math.min(this.lockedCounter - 1L, 10L));
        this.touching = false;
        ArrayList<Entity> entities = this.world.getEntities();
        int e = 0;
        while (e < entities.size()) {
            if (entities.get(e) instanceof Floor) {
                Floor c = (Floor)entities.get(e);
                if (Intersector.overlapCircleRectangle((Circle)new Circle(new Vector2(this.pos.x, this.pos.y), 1.0E-4f), (Rectangle)new Rectangle(c.pos.x - (float)World.BLOCKSIZE / 2.0f, c.pos.y - c.size.y + (float)World.BLOCKSIZE / 2.0f, c.size.x, c.size.y))) {
                    this.touching = true;
                    break;
                }
            }
            ++e;
        }
    }

    @Override
    public void draw() {
        float facA = Math.min((float)this.lockedCounter / 5.0f, 1.0f);
        float rFac = (float)(1.0 - (double)0.1f * (Math.sin((double)Rythm.getBeat() * Math.PI) * 0.5 + 0.5));
        float rpx = (float)Math.sin((double)Rythm.getBeat() + (double)(this.offset * 100.0f) * Math.PI);
        float rpy = (float)Math.cos((double)Rythm.getBeat() + (double)(this.offset * 100.0f) * Math.PI);
        GL11.glPushMatrix();
        Texture texture = Art.texture;
        texture.bind();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.touching) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        }
        GL11.glTranslatef((float)this.pos.x, (float)this.pos.y, (float)0.0f);
        if (!this.bonded) {
            GL11.glTranslatef((float)rpx, (float)rpy, (float)0.0f);
        }
        GL11.glScalef((float)(this.size.x * (1.0f - facA * 0.3f)), (float)(this.size.y * (1.0f - facA * 0.3f)), (float)1.0f);
        if (!this.bonded) {
            GL11.glScalef((float)rFac, (float)rFac, (float)0.0f);
        }
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)texture.getHeight());
        GL11.glVertex2f((float)-0.5f, (float)-0.5f);
        GL11.glTexCoord2f((float)texture.getWidth(), (float)texture.getHeight());
        GL11.glVertex2f((float)0.5f, (float)-0.5f);
        GL11.glTexCoord2f((float)texture.getWidth(), (float)0.0f);
        GL11.glVertex2f((float)0.5f, (float)0.5f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)-0.5f, (float)0.5f);
        GL11.glEnd();
        GL11.glPopMatrix();
        float facB = Math.max(0.0f, Math.min(1.0f, (float)(this.lockedCounter - 5L) / 3.0f));
        if (facB > 0.0f) {
            GL11.glPushMatrix();
            texture = Art.texture;
            texture.bind();
            GL11.glColor4f((float)(0.6f - 0.3f * (Rythm.getBeat() / 2.0f % 1.0f)), (float)(0.6f - 0.3f * (Rythm.getBeat() / 4.0f % 1.0f)), (float)0.6f, (float)1.0f);
            GL11.glTranslatef((float)this.pos.x, (float)this.pos.y, (float)0.0f);
            GL11.glScalef((float)(this.size.x * (facB * 0.5f)), (float)(this.size.y * (facB * 0.5f)), (float)1.0f);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)0.0f, (float)texture.getHeight());
            GL11.glVertex2f((float)-0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)texture.getWidth(), (float)texture.getHeight());
            GL11.glVertex2f((float)0.5f, (float)-0.5f);
            GL11.glTexCoord2f((float)texture.getWidth(), (float)0.0f);
            GL11.glVertex2f((float)0.5f, (float)0.5f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)-0.5f, (float)0.5f);
            GL11.glEnd();
            GL11.glPopMatrix();
        }
    }

    @Override
    public Vector2 getPos() {
        return null;
    }

    @Override
    public boolean isDead() {
        return !this.alive;
    }

    public void goThere(Vector2 p) {
        Vector2 dir = new Vector2(p).sub(this.pos);
        float origSpeed = dir.len();
        Vector2 dirNor = new Vector2(dir).mul(1.0f / dir.len());
        float speed = Math.min(origSpeed, 4.0f);
        if (speed > 0.0f) {
            this.v = this.v.mul(0.5f).add(new Vector2(dirNor).mul(speed * 0.5f));
        }
    }

    public void lock(boolean b) {
        this.locked = b;
    }
}

