/*
 * Decompiled with CFR 0.152.
 */
package com.bitbof.spinGame.entities;

import com.badlogic.gdx.math.Vector2;
import com.bitbof.spinGame.assets.Assets;
import com.bitbof.spinGame.entities.Entity;
import com.bitbof.spinGame.worlds.World;

public class Camera
extends Entity {
    public Vector2 pos;
    public Vector2 v;
    public Vector2 a;
    public float zoom;
    public World world;
    public long counter = 0L;
    public boolean crazyZoom = false;

    public Camera(World w) {
        this.world = w;
        this.pos = new Vector2(0.0f, 0.0f);
        this.v = new Vector2(0.0f, 0.0f);
        this.a = new Vector2(0.0f, 0.0f);
        this.zoom = 3.3f;
    }

    @Override
    public void update() {
        this.a = this.a.mul(0.6f);
        this.v = this.v.add(this.a).mul(0.95f);
        this.pos = this.pos.add(this.v);
        if (this.crazyZoom) {
            ++this.counter;
            float norm = (float)Math.min(250L, this.counter) / 250.0f;
            float easeIn = (float)Math.pow(Math.sin((double)norm * Math.PI / 2.0), 10.0);
            this.zoom = (float)((double)easeIn * 3.29995 + 5.0E-5);
        }
        if (this.counter > 320L) {
            this.crazyZoom = false;
        }
    }

    @Override
    public void draw() {
    }

    @Override
    public Vector2 getPos() {
        return null;
    }

    @Override
    public boolean isDead() {
        return false;
    }

    public boolean isZooming() {
        return this.crazyZoom;
    }

    public void doCrazyZoom() {
        this.counter = 0L;
        this.zoom = 5.0E-5f;
        this.crazyZoom = true;
        Assets.zoom.play();
    }
}

