/*
 * Decompiled with CFR 0.152.
 */
package com.bitbof.spinGame.entities;

import com.badlogic.gdx.math.Vector2;
import com.bitbof.spinGame.assets.Assets;
import com.bitbof.spinGame.entities.Creature;
import com.bitbof.spinGame.entities.DeathEffect;
import com.bitbof.spinGame.entities.Entity;
import com.bitbof.spinGame.worlds.World;
import java.util.ArrayList;
import org.lwjgl.input.Keyboard;

public class Bond
extends Entity {
    public World world;
    public ArrayList<Creature> creatures = new ArrayList();
    public int leader;
    public boolean locked = false;
    public float angle = 0.0f;
    public float rv;
    public Vector2 pos;
    public Vector2 v;
    public Vector2 a;
    public boolean kDown = false;
    public boolean alive = false;

    public Bond(World w) {
        this.world = w;
        this.pos = new Vector2(0.0f, 0.0f);
        this.v = new Vector2(0.0f, 0.0f);
        this.a = new Vector2(0.0f, 0.0f);
        this.alive = true;
        this.leader = 0;
    }

    public Creature getLeader() {
        if (this.leader == 0) {
            return this.creatures.get(0);
        }
        return this.creatures.get(this.creatures.size() - 1);
    }

    @Override
    public void update() {
        if (this.creatures.size() == 0) {
            this.alive = false;
            return;
        }
        if (Keyboard.isKeyDown((int)57) || Math.abs(this.rv) > 0.2f) {
            Vector2 p2;
            Vector2 p1;
            Vector2 newPos;
            float radius;
            Creature c;
            if (!this.locked) {
                this.locked = true;
                Assets.lock.play();
                this.getLeader().lock(true);
                this.rv = 0.0f;
                this.angle = new Vector2(this.creatures.get((int)0).pos).sub(new Vector2(this.creatures.get((int)(this.creatures.size() - 1)).pos)).angle();
                if (this.leader != 0) {
                    this.angle = new Vector2(this.creatures.get((int)(this.creatures.size() - 1)).pos).sub(new Vector2(this.creatures.get((int)0).pos)).angle();
                }
                this.v.mul(0.0f);
                this.a.mul(0.0f);
                this.angle += 180.0f;
                this.angle %= 360.0f;
            }
            Vector2 input = new Vector2(0.0f, 0.0f);
            if (Keyboard.isKeyDown((int)200)) {
                input.y = (float)((double)input.y + 0.1);
            }
            if (Keyboard.isKeyDown((int)208)) {
                input.y = (float)((double)input.y - 0.1);
            }
            if (Keyboard.isKeyDown((int)203)) {
                input.x = (float)((double)input.x - 0.1);
            }
            if (Keyboard.isKeyDown((int)205)) {
                input.x = (float)((double)input.x + 0.1);
            }
            if (input.len() > 0.0f) {
                this.rv = this.angleDir(this.angle, input.angle()) * 0.1f;
            }
            this.angle += this.rv;
            this.angle %= 360.0f;
            this.rv *= 0.6f;
            if (this.leader == 0) {
                c = this.creatures.get(0);
                c.v = c.v.mul(0.0f);
                c = this.creatures.get(this.creatures.size() - 1);
                radius = (this.creatures.size() - 1) * 10;
                newPos = new Vector2((float)Math.cos((double)(this.angle / 180.0f) * Math.PI), (float)Math.sin((double)(this.angle / 180.0f) * Math.PI));
                newPos.mul(radius);
                newPos.add(this.pos);
                c.pos = newPos;
                p1 = new Vector2(this.pos);
                p2 = new Vector2(this.creatures.get((int)(this.creatures.size() - 1)).pos);
            } else {
                c = this.creatures.get(this.creatures.size() - 1);
                c.v = c.v.mul(0.0f);
                c = this.creatures.get(0);
                radius = (this.creatures.size() - 1) * 10;
                newPos = new Vector2((float)Math.cos((double)(this.angle / 180.0f) * Math.PI), (float)Math.sin((double)(this.angle / 180.0f) * Math.PI));
                newPos.mul(radius);
                newPos.add(this.pos);
                c.pos = newPos;
                p2 = new Vector2(this.creatures.get((int)0).pos);
                p1 = new Vector2(this.creatures.get((int)(this.creatures.size() - 1)).pos);
            }
            int i = 1;
            while (i < this.creatures.size() - 1) {
                Creature c2 = this.creatures.get(i);
                float fac = (float)i / ((float)this.creatures.size() - 1.0f);
                c2.pos = this.leader == 0 ? new Vector2(p1).mul(1.0f - fac).add(new Vector2(p2).mul(fac)) : new Vector2(p1).mul(fac).add(new Vector2(p2).mul(1.0f - fac));
                ++i;
            }
        } else {
            Vector2 p2;
            Vector2 p1;
            Vector2 newPos;
            Vector2 dir;
            float radius;
            Creature c;
            if (this.locked) {
                this.locked = false;
                this.getLeader().lock(false);
                this.rv = 0.0f;
                this.toggleLeader();
                Assets.unlock.play();
            }
            boolean skipped = false;
            int i = 0;
            while (i < this.creatures.size()) {
                Creature c3 = this.creatures.get(i);
                if (!c3.touching) {
                    DeathEffect eff = new DeathEffect(this.world);
                    eff.pos = new Vector2(c3.pos);
                    this.creatures.remove(i--);
                    c3.alive = false;
                    Assets.playDeath();
                    this.world.getEntities().add(eff);
                }
                ++i;
            }
            if (this.creatures.size() == 0) {
                this.alive = false;
                return;
            }
            Vector2 input = new Vector2(0.0f, 0.0f);
            if (Keyboard.isKeyDown((int)200)) {
                input.y = (float)((double)input.y + 0.1);
            }
            if (Keyboard.isKeyDown((int)208)) {
                input.y = (float)((double)input.y - 0.1);
            }
            if (Keyboard.isKeyDown((int)203)) {
                input.x = (float)((double)input.x - 0.1);
            }
            if (Keyboard.isKeyDown((int)205)) {
                input.x = (float)((double)input.x + 0.1);
            }
            input.mul(0.5f);
            float bondAngle = new Vector2(this.creatures.get((int)0).pos).sub(new Vector2(this.creatures.get((int)(this.creatures.size() - 1)).pos)).angle();
            if (this.leader != 0) {
                bondAngle = new Vector2(this.creatures.get((int)(this.creatures.size() - 1)).pos).sub(new Vector2(this.creatures.get((int)0).pos)).angle();
            }
            float inAngle = input.angle();
            if (input.len() > 0.0f && this.angleDifference(inAngle, bondAngle) > 130.0f) {
                this.toggleLeader();
            }
            this.a = this.a.add(input);
            if (Keyboard.isKeyDown((int)11)) {
                if (!this.kDown) {
                    Creature c4;
                    this.kDown = true;
                    if (this.leader == 0) {
                        this.leader = 1;
                        c4 = this.creatures.get(this.creatures.size() - 1);
                        this.pos = new Vector2(c4.pos);
                    } else {
                        this.leader = 0;
                        c4 = this.creatures.get(0);
                        this.pos = new Vector2(c4.pos);
                    }
                }
            } else {
                this.kDown = false;
            }
            this.a = this.a.mul(0.9f);
            this.v = this.v.add(this.a).mul(0.8f);
            if (this.leader == 0) {
                this.pos = this.pos.add(this.v);
                c = this.creatures.get(0);
                c.goThere(new Vector2(this.pos));
                this.pos = new Vector2(c.pos);
                c = this.creatures.get(this.creatures.size() - 1);
                radius = (this.creatures.size() - 1) * 10;
                dir = new Vector2(this.pos).sub(c.pos);
                dir.mul(-radius / dir.len());
                newPos = new Vector2(this.pos).add(dir);
                c.goThere(newPos);
                p1 = new Vector2(this.pos);
                p2 = new Vector2(this.creatures.get((int)(this.creatures.size() - 1)).pos);
            } else {
                c = this.creatures.get(this.creatures.size() - 1);
                this.pos = this.pos.add(this.v);
                c.goThere(new Vector2(this.pos));
                this.pos = new Vector2(c.pos);
                c = this.creatures.get(0);
                radius = (this.creatures.size() - 1) * 10;
                dir = new Vector2(this.pos).sub(c.pos);
                dir.mul(-radius / dir.len());
                newPos = new Vector2(this.pos).add(dir);
                c.goThere(newPos);
                p2 = new Vector2(this.creatures.get((int)0).pos);
                p1 = new Vector2(this.creatures.get((int)(this.creatures.size() - 1)).pos);
            }
            int i2 = 1;
            while (i2 < this.creatures.size() - 1) {
                Creature c5 = this.creatures.get(i2);
                float fac = (float)i2 / ((float)this.creatures.size() - 1.0f);
                if (this.leader == 0) {
                    c5.goThere(new Vector2(p1).mul(1.0f - fac).add(new Vector2(p2).mul(fac)));
                } else {
                    c5.goThere(new Vector2(p1).mul(fac).add(new Vector2(p2).mul(1.0f - fac)));
                }
                ++i2;
            }
            this.checkPickup();
        }
    }

    @Override
    public void draw() {
    }

    @Override
    public Vector2 getPos() {
        return null;
    }

    @Override
    public boolean isDead() {
        return !this.alive;
    }

    public Vector2 getCenter() {
        if (!this.alive) {
            return new Vector2(this.pos);
        }
        return new Vector2(this.creatures.get((int)0).pos).mul(0.5f).add(new Vector2(this.creatures.get((int)(this.creatures.size() - 1)).pos).mul(0.5f));
    }

    public float angleDifference(float a1, float a2) {
        float dif = Math.abs(a1 - a2) % 360.0f;
        if (dif > 180.0f) {
            dif = 360.0f - dif;
        }
        return dif;
    }

    public float angleDir(float a1, float a2) {
        while (a1 < 0.0f) {
            a1 += 360.0f;
        }
        while (a2 < 0.0f) {
            a2 += 360.0f;
        }
        float result = (a2 %= 360.0f) - (a1 %= 360.0f);
        if (result < -180.0f) {
            result += 360.0f;
        }
        if (result > 180.0f) {
            result -= 360.0f;
        }
        return result;
    }

    public void toggleLeader() {
        if (this.leader == 0) {
            this.leader = 1;
            Creature c = this.creatures.get(this.creatures.size() - 1);
            this.pos = new Vector2(c.pos);
            this.v = new Vector2(c.v);
        } else {
            this.leader = 0;
            Creature c = this.creatures.get(0);
            this.pos = new Vector2(c.pos);
            this.v = new Vector2(c.v);
        }
    }

    public void checkPickup() {
        ArrayList<Entity> entities = this.world.getEntities();
        int i = 0;
        while (i < this.creatures.size()) {
            int e = 0;
            while (e < entities.size()) {
                if (entities.get(e) instanceof Creature) {
                    float dist;
                    Creature c = (Creature)entities.get(e);
                    if (!c.bonded && (dist = c.pos.dst(this.creatures.get((int)i).pos)) < c.radius * 2.0f) {
                        this.creatures.add(i, c);
                        c.bonded = true;
                        Assets.collect.play();
                    }
                }
                ++e;
            }
            ++i;
        }
    }

    public void add(Creature cr) {
        if (cr.bonded) {
            return;
        }
        this.creatures.add(cr);
        cr.bonded = true;
    }
}

