/*
 * Decompiled with CFR 0.152.
 */
package com.bitbof.spinGame;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.FPSLogger;
import com.bitbof.spinGame.screens.Screen;

public abstract class Game
implements ApplicationListener {
    Screen screen;
    FPSLogger fpsLogger;

    public void setScreen(Screen screen) {
        this.screen.pause();
        this.screen.dispose();
        this.screen = screen;
    }

    public abstract Screen getStartScreen();

    public void create() {
        this.screen = this.getStartScreen();
    }

    public void render() {
        this.screen.update(Gdx.graphics.getDeltaTime());
        this.screen.present(Gdx.graphics.getDeltaTime());
        if (this.fpsLogger != null) {
            this.fpsLogger.log();
        }
    }

    public void resume() {
        this.screen.resume();
    }

    public void pause() {
        this.screen.pause();
    }

    public void resize(int width, int height) {
        this.screen.resize(width, height);
    }

    public void dispose() {
        this.screen.dispose();
    }
}

