/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Util;

public final class AMDNameGenDelete {
    public static final int GL_DATA_BUFFER_AMD = 37201;
    public static final int GL_PERFORMANCE_MONITOR_AMD = 37202;
    public static final int GL_QUERY_OBJECT_AMD = 37203;
    public static final int GL_VERTEX_ARRAY_OBJECT_AMD = 37204;
    public static final int GL_SAMPLER_OBJECT_AMD = 37205;

    private AMDNameGenDelete() {
    }

    public static void glGenNamesAMD(int identifier, IntBuffer names) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGenNamesAMD;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(names);
        AMDNameGenDelete.nglGenNamesAMD(identifier, names.remaining(), names, names.position(), function_pointer);
        Util.checkGLError();
    }

    static native void nglGenNamesAMD(int var0, int var1, IntBuffer var2, int var3, long var4);

    public static int glGenNamesAMD(int identifier) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGenNamesAMD;
        BufferChecks.checkFunctionAddress(function_pointer);
        IntBuffer names = APIUtil.getBufferInt();
        AMDNameGenDelete.nglGenNamesAMD(identifier, 1, names, names.position(), function_pointer);
        Util.checkGLError();
        return names.get(0);
    }

    public static void glDeleteNamesAMD(int identifier, IntBuffer names) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDeleteNamesAMD;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkDirect(names);
        AMDNameGenDelete.nglDeleteNamesAMD(identifier, names.remaining(), names, names.position(), function_pointer);
        Util.checkGLError();
    }

    static native void nglDeleteNamesAMD(int var0, int var1, IntBuffer var2, int var3, long var4);

    public static void glDeleteNamesAMD(int identifier, int name) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDeleteNamesAMD;
        BufferChecks.checkFunctionAddress(function_pointer);
        AMDNameGenDelete.nglDeleteNamesAMD(identifier, 1, APIUtil.getBufferInt().put(0, name), 0, function_pointer);
        Util.checkGLError();
    }

    public static boolean glIsNameAMD(int identifier, int name) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glIsNameAMD;
        BufferChecks.checkFunctionAddress(function_pointer);
        boolean __result = AMDNameGenDelete.nglIsNameAMD(identifier, name, function_pointer);
        Util.checkGLError();
        return __result;
    }

    static native boolean nglIsNameAMD(int var0, int var1, long var2);
}

