/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.applet;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletLoader
extends Applet
implements Runnable,
AppletStub {
    public static final int STATE_INIT = 1;
    public static final int STATE_DETERMINING_PACKAGES = 2;
    public static final int STATE_CHECKING_CACHE = 3;
    public static final int STATE_DOWNLOADING = 4;
    public static final int STATE_EXTRACTING_PACKAGES = 5;
    public static final int STATE_UPDATING_CLASSPATH = 6;
    public static final int STATE_SWITCHING_APPLET = 7;
    public static final int STATE_INITIALIZE_REAL_APPLET = 8;
    public static final int STATE_START_REAL_APPLET = 9;
    public static final int STATE_DONE = 10;
    protected int percentage;
    protected int currentSizeDownload;
    protected int totalSizeDownload;
    protected int currentSizeExtract;
    protected int totalSizeExtract;
    protected Image logo;
    protected Image logoBuffer;
    protected Image progressbar;
    protected Image progressbarBuffer;
    protected Image offscreen;
    protected boolean painting;
    protected Color bgColor = Color.white;
    protected Color fgColor = Color.black;
    protected URL[] urlList;
    protected ClassLoader classLoader;
    protected Thread loaderThread;
    protected Thread animationThread;
    protected Applet lwjglApplet;
    protected boolean fatalError;
    protected boolean debugMode;
    protected boolean prependHost;
    protected HashMap<String, Long> filesLastModified;
    protected int[] fileSizes;
    protected int nativeJarCount;
    protected boolean cacheEnabled;
    protected String subtaskMessage = "";
    protected volatile int state = 1;
    protected boolean lzmaSupported;
    protected boolean pack200Supported;
    protected String[] genericErrorMessage = new String[]{"An error occured while loading the applet.", "Please contact support to resolve this issue.", "<placeholder for error message>"};
    protected boolean certificateRefused;
    protected String[] certificateRefusedMessage = new String[]{"Permissions for Applet Refused.", "Please accept the permissions dialog to allow", "the applet to continue the loading process."};
    protected static boolean natives_loaded;

    @Override
    public void init() {
        String[] requiredArgs;
        this.setState(1);
        for (String requiredArg : requiredArgs = new String[]{"al_main", "al_logo", "al_progressbar", "al_jars"}) {
            if (this.getParameter(requiredArg) != null) continue;
            this.fatalErrorOccured("missing required applet parameter: " + requiredArg, null);
            return;
        }
        this.cacheEnabled = this.getBooleanParameter("al_cache", true);
        this.debugMode = this.getBooleanParameter("al_debug", false);
        this.prependHost = this.getBooleanParameter("al_prepend_host", true);
        this.bgColor = this.getColor("boxbgcolor", Color.white);
        this.setBackground(this.bgColor);
        this.fgColor = this.getColor("boxfgcolor", Color.black);
        if (this.getParameter("al_logo").length() > 0) {
            this.logo = this.getImage(this.getParameter("al_logo"));
        }
        if (this.getParameter("al_progressbar").length() > 0) {
            this.progressbar = this.getImage(this.getParameter("al_progressbar"));
        }
        try {
            Class.forName("LZMA.LzmaInputStream");
            this.lzmaSupported = true;
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            Pack200.class.getSimpleName();
            this.pack200Supported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String generateStacktrace(Exception exception) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        exception.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    @Override
    public void start() {
        if (this.lwjglApplet != null) {
            this.lwjglApplet.start();
        } else if (this.loaderThread == null && !this.fatalError) {
            this.loaderThread = new Thread(this);
            this.loaderThread.setName("AppletLoader.loaderThread");
            this.loaderThread.start();
            this.animationThread = new Thread(){

                public void run() {
                    while (AppletLoader.this.loaderThread != null) {
                        AppletLoader.this.repaint();
                        AppletLoader.this.sleep(100L);
                    }
                    AppletLoader.this.animationThread = null;
                }
            };
            this.animationThread.setName("AppletLoader.animationthread");
            this.animationThread.start();
        }
    }

    @Override
    public void stop() {
        if (this.lwjglApplet != null) {
            this.lwjglApplet.stop();
        }
    }

    @Override
    public void destroy() {
        if (this.lwjglApplet != null) {
            this.lwjglApplet.destroy();
        }
    }

    protected void cleanUp() {
        this.progressbar = null;
        this.logo = null;
        this.logoBuffer = null;
        this.progressbarBuffer = null;
        this.offscreen = null;
    }

    public Applet getApplet() {
        return this.lwjglApplet;
    }

    @Override
    public void appletResize(int width, int height) {
        this.resize(width, height);
    }

    @Override
    public final void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.state == 10) {
            this.cleanUp();
            return;
        }
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.getWidth(), this.getHeight());
            if (this.logo != null) {
                this.logoBuffer = this.createImage(this.logo.getWidth(null), this.logo.getHeight(null));
                this.offscreen.getGraphics().drawImage(this.logo, 0, 0, this);
                this.imageUpdate(this.logo, 16, 0, 0, 0, 0);
            }
            if (this.progressbar != null) {
                this.progressbarBuffer = this.createImage(this.progressbar.getWidth(null), this.progressbar.getHeight(null));
                this.offscreen.getGraphics().drawImage(this.progressbar, 0, 0, this);
                this.imageUpdate(this.progressbar, 16, 0, 0, 0, 0);
            }
        }
        Graphics og = this.offscreen.getGraphics();
        FontMetrics fm = og.getFontMetrics();
        og.setColor(this.bgColor);
        og.fillRect(0, 0, this.offscreen.getWidth(null), this.offscreen.getHeight(null));
        og.setColor(this.fgColor);
        String message = this.getDescriptionForState();
        if (this.fatalError) {
            String[] errorMessage = this.certificateRefused ? this.certificateRefusedMessage : this.genericErrorMessage;
            for (int i = 0; i < errorMessage.length; ++i) {
                if (errorMessage[i] == null) continue;
                int messageX = (this.offscreen.getWidth(null) - fm.stringWidth(errorMessage[i])) / 2;
                int messageY = (this.offscreen.getHeight(null) - fm.getHeight() * errorMessage.length) / 2;
                og.drawString(errorMessage[i], messageX, messageY + i * fm.getHeight());
            }
        } else {
            og.setColor(this.fgColor);
            this.painting = true;
            int x = this.offscreen.getWidth(null) / 2;
            int y = this.offscreen.getHeight(null) / 2;
            if (this.logo != null) {
                og.drawImage(this.logoBuffer, x - this.logo.getWidth(null) / 2, y - this.logo.getHeight(null) / 2, this);
            }
            int messageX = (this.offscreen.getWidth(null) - fm.stringWidth(message)) / 2;
            int messageY = y + 20;
            if (this.logo != null) {
                messageY += this.logo.getHeight(null) / 2;
            } else if (this.progressbar != null) {
                messageY += this.progressbar.getHeight(null) / 2;
            }
            og.drawString(message, messageX, messageY);
            if (this.subtaskMessage.length() > 0) {
                messageX = (this.offscreen.getWidth(null) - fm.stringWidth(this.subtaskMessage)) / 2;
                og.drawString(this.subtaskMessage, messageX, messageY + 20);
            }
            if (this.progressbar != null) {
                int barSize = this.progressbar.getWidth(null) * this.percentage / 100;
                og.clipRect(x - this.progressbar.getWidth(null) / 2, 0, barSize, this.offscreen.getHeight(null));
                og.drawImage(this.progressbarBuffer, x - this.progressbar.getWidth(null) / 2, y - this.progressbar.getHeight(null) / 2, this);
            }
            this.painting = false;
        }
        og.dispose();
        g.drawImage(this.offscreen, (this.getWidth() - this.offscreen.getWidth(null)) / 2, (this.getHeight() - this.offscreen.getHeight(null)) / 2, null);
    }

    @Override
    public boolean imageUpdate(Image img, int flag, int x, int y, int width, int height) {
        if (this.state == 10) {
            return false;
        }
        if (flag == 16 && !this.painting) {
            Image buffer = img == this.logo ? this.logoBuffer : this.progressbarBuffer;
            Graphics g = buffer.getGraphics();
            g.setColor(this.bgColor);
            g.fillRect(0, 0, buffer.getWidth(null), buffer.getHeight(null));
            if (img == this.progressbar && this.logo != null) {
                g.drawImage(this.logoBuffer, this.progressbar.getWidth(null) / 2 - this.logo.getWidth(null) / 2, this.progressbar.getHeight(null) / 2 - this.logo.getHeight(null) / 2, null);
            }
            g.drawImage(img, 0, 0, this);
            g.dispose();
            this.repaint();
        }
        return true;
    }

    protected String getDescriptionForState() {
        switch (this.state) {
            case 1: {
                return "Initializing loader";
            }
            case 2: {
                return "Determining packages to load";
            }
            case 3: {
                return "Calculating download size";
            }
            case 4: {
                return "Downloading packages";
            }
            case 5: {
                return "Extracting downloaded packages";
            }
            case 6: {
                return "Updating classpath";
            }
            case 7: {
                return "Switching applet";
            }
            case 8: {
                return "Initializing real applet";
            }
            case 9: {
                return "Starting real applet";
            }
            case 10: {
                return "Done loading";
            }
        }
        return "unknown state";
    }

    protected String trimExtensionByCapabilities(String file) {
        if (!this.pack200Supported) {
            file = file.replaceAll(".pack", "");
        }
        if (!this.lzmaSupported) {
            file = file.replaceAll(".lzma", "");
        }
        return file;
    }

    protected void loadJarURLs() throws Exception {
        int i;
        this.setState(2);
        String jarList = this.getParameter("al_jars");
        String nativeJarList = null;
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Win")) {
            nativeJarList = System.getProperty("os.arch").endsWith("64") ? this.getParameter("al_windows64") : this.getParameter("al_windows32");
            if (nativeJarList == null) {
                nativeJarList = this.getParameter("al_windows");
            }
        } else if (osName.startsWith("Linux")) {
            nativeJarList = System.getProperty("os.arch").endsWith("64") ? this.getParameter("al_linux64") : this.getParameter("al_linux32");
            if (nativeJarList == null) {
                nativeJarList = this.getParameter("al_linux");
            }
        } else if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
            nativeJarList = this.getParameter("al_mac");
        } else if (osName.startsWith("Solaris") || osName.startsWith("SunOS")) {
            nativeJarList = this.getParameter("al_solaris");
        } else if (osName.startsWith("FreeBSD")) {
            nativeJarList = this.getParameter("al_freebsd");
        } else {
            this.fatalErrorOccured("OS (" + osName + ") not supported", null);
            return;
        }
        if (nativeJarList == null) {
            this.fatalErrorOccured("no lwjgl natives files found", null);
            return;
        }
        jarList = this.trimExtensionByCapabilities(jarList);
        StringTokenizer jars = new StringTokenizer(jarList, ", ");
        nativeJarList = this.trimExtensionByCapabilities(nativeJarList);
        StringTokenizer nativeJars = new StringTokenizer(nativeJarList, ", ");
        int jarCount = jars.countTokens();
        this.nativeJarCount = nativeJars.countTokens();
        this.urlList = new URL[jarCount + this.nativeJarCount];
        URL path = this.getCodeBase();
        for (i = 0; i < jarCount; ++i) {
            this.urlList[i] = new URL(path, jars.nextToken());
        }
        for (i = jarCount; i < jarCount + this.nativeJarCount; ++i) {
            this.urlList[i] = new URL(path, nativeJars.nextToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setState(3);
        this.percentage = 5;
        try {
            this.debug_sleep(2000L);
            this.loadJarURLs();
            String path = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    String codebase = "";
                    if (AppletLoader.this.prependHost) {
                        codebase = AppletLoader.this.getCodeBase().getHost();
                        if (codebase == null || codebase.length() == 0) {
                            codebase = "localhost";
                        }
                        codebase = codebase + File.separator;
                    }
                    return AppletLoader.this.getCacheDir() + File.separator + codebase + AppletLoader.this.getParameter("al_title") + File.separator;
                }
            });
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File versionFile = new File(dir, "version");
            boolean versionAvailable = false;
            String version = this.getParameter("al_version");
            float latestVersion = 0.0f;
            if (version != null) {
                latestVersion = Float.parseFloat(version);
                if (versionFile.exists() && latestVersion != this.readVersionFile(versionFile)) {
                    versionAvailable = true;
                    this.percentage = 90;
                    if (this.debugMode) {
                        System.out.println("Loading Cached Applet Version " + latestVersion);
                    }
                    this.debug_sleep(2000L);
                }
            }
            if (!versionAvailable) {
                this.getJarInfo(dir);
                this.downloadJars(path);
                this.extractJars(path);
                this.extractNatives(path);
                if (version != null) {
                    this.percentage = 90;
                    this.writeVersionFile(versionFile, latestVersion);
                }
                this.writeCacheFile(new File(dir, "cache"), this.filesLastModified);
            }
            this.updateClassPath(path);
            this.setLWJGLProperties();
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        AppletLoader.this.switchApplet();
                    }
                    catch (Exception e) {
                        AppletLoader.this.fatalErrorOccured("This occurred while '" + AppletLoader.this.getDescriptionForState() + "'", e);
                    }
                    AppletLoader.this.setState(10);
                    AppletLoader.this.repaint();
                }
            });
        }
        catch (AccessControlException ace) {
            this.fatalErrorOccured(ace.getMessage(), ace);
            this.certificateRefused = true;
        }
        catch (Exception e) {
            this.fatalErrorOccured("This occurred while '" + this.getDescriptionForState() + "'", e);
        }
        finally {
            this.loaderThread = null;
        }
    }

    protected void setLWJGLProperties() {
        String lwjglArguments = this.getParameter("lwjgl_arguments");
        if (lwjglArguments != null && lwjglArguments.length() > 0) {
            int start = lwjglArguments.indexOf("-Dorg.lwjgl");
            while (start != -1) {
                int end = lwjglArguments.indexOf(" ", start);
                if (end == -1) {
                    end = lwjglArguments.length();
                }
                String[] keyValue = lwjglArguments.substring(start + 2, end).split("=");
                System.setProperty(keyValue[0], keyValue[1]);
                if (this.debugMode) {
                    System.out.println("Setting property " + keyValue[0] + " to " + keyValue[1]);
                }
                start = lwjglArguments.indexOf("-Dorg.lwjgl", end);
            }
        }
    }

    protected String getCacheDir() {
        String cacheDir = System.getProperty("deployment.user.cachedir");
        if (cacheDir == null || System.getProperty("os.name").startsWith("Win")) {
            cacheDir = System.getProperty("java.io.tmpdir");
        }
        return cacheDir + File.separator + "lwjglcache";
    }

    protected float readVersionFile(File file) throws Exception {
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        float version = dis.readFloat();
        dis.close();
        return version;
    }

    protected void writeVersionFile(File file, float version) throws Exception {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));
        dos.writeFloat(version);
        dos.close();
    }

    protected HashMap<String, Long> readCacheFile(File file) throws Exception {
        ObjectInputStream dis = new ObjectInputStream(new FileInputStream(file));
        HashMap hashMap = (HashMap)dis.readObject();
        dis.close();
        return hashMap;
    }

    protected void writeCacheFile(File file, HashMap<String, Long> filesLastModified) throws Exception {
        ObjectOutputStream dos = new ObjectOutputStream(new FileOutputStream(file));
        dos.writeObject(filesLastModified);
        dos.close();
    }

    protected void updateClassPath(final String path) throws Exception {
        this.setState(6);
        this.percentage = 95;
        URL[] urls = new URL[this.urlList.length];
        for (int i = 0; i < this.urlList.length; ++i) {
            urls[i] = new URL("file:" + path + this.getJarName(this.urlList[i]));
        }
        this.classLoader = new URLClassLoader(urls){

            protected PermissionCollection getPermissions(CodeSource codesource) {
                PermissionCollection perms = null;
                try {
                    Method method = SecureClassLoader.class.getDeclaredMethod("getPermissions", CodeSource.class);
                    method.setAccessible(true);
                    perms = (PermissionCollection)method.invoke((Object)this.getClass().getClassLoader(), codesource);
                    String host = AppletLoader.this.getCodeBase().getHost();
                    if (host != null && host.length() > 0) {
                        perms.add(new SocketPermission(host, "connect,accept"));
                    } else if ("file".equals(codesource.getLocation().getProtocol())) {
                        String path2 = codesource.getLocation().getFile().replace('/', File.separatorChar);
                        perms.add(new FilePermission(path2, "read"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return perms;
            }

            protected String findLibrary(String libname) {
                return path + "natives" + File.separator + System.mapLibraryName(libname);
            }
        };
        this.debug_sleep(2000L);
        this.unloadNatives(path);
        System.setProperty("org.lwjgl.librarypath", path + "natives");
        System.setProperty("net.java.games.input.librarypath", path + "natives");
        System.setProperty("java.library.path", path + "natives");
        natives_loaded = true;
    }

    private void unloadNatives(String nativePath) {
        if (!natives_loaded) {
            return;
        }
        try {
            Field field = ClassLoader.class.getDeclaredField("loadedLibraryNames");
            field.setAccessible(true);
            Vector libs = (Vector)field.get(this.getClass().getClassLoader());
            String path = new File(nativePath).getCanonicalPath();
            for (int i = 0; i < libs.size(); ++i) {
                String s = (String)libs.get(i);
                if (!s.startsWith(path)) continue;
                libs.remove(i);
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void switchApplet() throws Exception {
        this.setState(7);
        this.percentage = 100;
        this.debug_sleep(2000L);
        Class<?> appletClass = this.classLoader.loadClass(this.getParameter("al_main"));
        this.lwjglApplet = (Applet)appletClass.newInstance();
        this.lwjglApplet.setStub(this);
        this.lwjglApplet.setSize(this.getWidth(), this.getHeight());
        this.setLayout(new BorderLayout());
        this.add(this.lwjglApplet);
        this.validate();
        this.setState(8);
        this.lwjglApplet.init();
        this.setState(9);
        this.lwjglApplet.start();
    }

    protected void getJarInfo(File dir) throws Exception {
        this.filesLastModified = new HashMap();
        this.fileSizes = new int[this.urlList.length];
        File cacheFile = new File(dir, "cache");
        if (cacheFile.exists()) {
            this.filesLastModified = this.readCacheFile(cacheFile);
        }
        for (int i = 0; i < this.urlList.length; ++i) {
            long savedLastModified;
            URLConnection urlconnection = this.urlList[i].openConnection();
            urlconnection.setDefaultUseCaches(false);
            if (urlconnection instanceof HttpURLConnection) {
                ((HttpURLConnection)urlconnection).setRequestMethod("HEAD");
            }
            this.fileSizes[i] = urlconnection.getContentLength();
            long lastModified = urlconnection.getLastModified();
            String fileName = this.getFileName(this.urlList[i]);
            if (this.cacheEnabled && lastModified != 0L && this.filesLastModified.containsKey(fileName) && (savedLastModified = this.filesLastModified.get(fileName).longValue()) == lastModified) {
                this.fileSizes[i] = -2;
            }
            if (this.fileSizes[i] >= 0) {
                this.totalSizeDownload += this.fileSizes[i];
            }
            this.filesLastModified.put(fileName, lastModified);
            this.percentage = 5 + (int)((float)(10 * i) / (float)this.urlList.length);
        }
    }

    protected void downloadJars(String path) throws Exception {
        this.setState(4);
        this.percentage = 15;
        int initialPercentage = 15;
        byte[] buffer = new byte[65536];
        for (int i = 0; i < this.urlList.length; ++i) {
            if (this.fileSizes[i] == -2) continue;
            int unsuccessfulAttempts = 0;
            int maxUnsuccessfulAttempts = 3;
            boolean downloadFile = true;
            while (downloadFile) {
                int bufferSize;
                downloadFile = false;
                this.debug_sleep(2000L);
                URLConnection urlconnection = this.urlList[i].openConnection();
                if (urlconnection instanceof HttpURLConnection) {
                    urlconnection.setRequestProperty("Cache-Control", "no-cache");
                    urlconnection.connect();
                }
                String currentFile = this.getFileName(this.urlList[i]);
                InputStream inputstream = this.getJarInputStream(currentFile, urlconnection);
                FileOutputStream fos = new FileOutputStream(path + currentFile);
                long downloadStartTime = System.currentTimeMillis();
                int downloadedAmount = 0;
                int fileSize = 0;
                String downloadSpeedMessage = "";
                while ((bufferSize = inputstream.read(buffer, 0, buffer.length)) != -1) {
                    this.debug_sleep(10L);
                    fos.write(buffer, 0, bufferSize);
                    this.currentSizeDownload += bufferSize;
                    fileSize += bufferSize;
                    this.percentage = initialPercentage + this.currentSizeDownload * 45 / this.totalSizeDownload;
                    this.subtaskMessage = "Retrieving: " + currentFile + " " + this.currentSizeDownload * 100 / this.totalSizeDownload + "%";
                    downloadedAmount += bufferSize;
                    long timeLapse = System.currentTimeMillis() - downloadStartTime;
                    if (timeLapse >= 1000L) {
                        float downloadSpeed = (float)downloadedAmount / (float)timeLapse;
                        downloadSpeed = (float)((int)(downloadSpeed * 100.0f)) / 100.0f;
                        downloadSpeedMessage = " - " + downloadSpeed + " KB/sec";
                        downloadedAmount = 0;
                        downloadStartTime = System.currentTimeMillis();
                    }
                    this.subtaskMessage = this.subtaskMessage + downloadSpeedMessage;
                }
                inputstream.close();
                fos.close();
                if (!(urlconnection instanceof HttpURLConnection) || fileSize == this.fileSizes[i] || this.fileSizes[i] <= 0) continue;
                if (++unsuccessfulAttempts < maxUnsuccessfulAttempts) {
                    downloadFile = true;
                    this.currentSizeDownload -= fileSize;
                    continue;
                }
                throw new Exception("failed to download " + currentFile);
            }
        }
        this.subtaskMessage = "";
    }

    protected InputStream getJarInputStream(String currentFile, final URLConnection urlconnection) throws Exception {
        final InputStream[] is = new InputStream[1];
        for (int j = 0; j < 3 && is[0] == null; ++j) {
            Thread t = new Thread(){

                public void run() {
                    try {
                        is[0] = urlconnection.getInputStream();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            t.setName("JarInputStreamThread");
            t.start();
            int iterationCount = 0;
            while (is[0] == null && iterationCount++ < 5) {
                try {
                    t.join(1000L);
                }
                catch (InterruptedException inte) {}
            }
            if (is[0] != null) continue;
            try {
                t.interrupt();
                t.join();
                continue;
            }
            catch (InterruptedException inte) {
                // empty catch block
            }
        }
        if (is[0] == null) {
            throw new Exception("Unable to get input stream for " + currentFile);
        }
        return is[0];
    }

    protected void extractLZMA(String in, String out) throws Exception {
        File f = new File(in);
        FileInputStream fileInputHandle = new FileInputStream(f);
        Class<?> clazz = Class.forName("LZMA.LzmaInputStream");
        Constructor<?> constructor = clazz.getDeclaredConstructor(InputStream.class);
        InputStream inputHandle = (InputStream)constructor.newInstance(fileInputHandle);
        FileOutputStream outputHandle = new FileOutputStream(out);
        byte[] buffer = new byte[16384];
        int ret = inputHandle.read(buffer);
        while (ret >= 1) {
            ((OutputStream)outputHandle).write(buffer, 0, ret);
            ret = inputHandle.read(buffer);
        }
        inputHandle.close();
        ((OutputStream)outputHandle).close();
        outputHandle = null;
        inputHandle = null;
        f.delete();
    }

    protected void extractGZip(String in, String out) throws Exception {
        File f = new File(in);
        FileInputStream fileInputHandle = new FileInputStream(f);
        GZIPInputStream inputHandle = new GZIPInputStream(fileInputHandle);
        FileOutputStream outputHandle = new FileOutputStream(out);
        byte[] buffer = new byte[16384];
        int ret = ((InputStream)inputHandle).read(buffer);
        while (ret >= 1) {
            ((OutputStream)outputHandle).write(buffer, 0, ret);
            ret = ((InputStream)inputHandle).read(buffer);
        }
        ((InputStream)inputHandle).close();
        ((OutputStream)outputHandle).close();
        outputHandle = null;
        inputHandle = null;
        f.delete();
    }

    protected void extractPack(String in, String out) throws Exception {
        File f = new File(in);
        FileOutputStream fostream = new FileOutputStream(out);
        JarOutputStream jostream = new JarOutputStream(fostream);
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        unpacker.unpack(f, jostream);
        jostream.close();
        f.delete();
    }

    protected void extractJars(String path) throws Exception {
        this.setState(5);
        float increment = 10.0f / (float)this.urlList.length;
        for (int i = 0; i < this.urlList.length; ++i) {
            if (this.fileSizes[i] == -2) continue;
            this.percentage = 55 + (int)(increment * (float)(i + 1));
            String filename = this.getFileName(this.urlList[i]);
            if (filename.endsWith(".pack.lzma")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + filename.replaceAll(".lzma", "");
                this.debug_sleep(1000L);
                this.extractLZMA(path + filename, path + filename.replaceAll(".lzma", ""));
                this.subtaskMessage = "Extracting: " + filename.replaceAll(".lzma", "") + " to " + filename.replaceAll(".pack.lzma", "");
                this.debug_sleep(1000L);
                this.extractPack(path + filename.replaceAll(".lzma", ""), path + filename.replaceAll(".pack.lzma", ""));
                continue;
            }
            if (filename.endsWith(".pack.gz")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + filename.replaceAll(".gz", "");
                this.debug_sleep(1000L);
                this.extractGZip(path + filename, path + filename.replaceAll(".gz", ""));
                this.subtaskMessage = "Extracting: " + filename.replaceAll(".gz", "") + " to " + filename.replaceAll(".pack.gz", "");
                this.debug_sleep(1000L);
                this.extractPack(path + filename.replaceAll(".gz", ""), path + filename.replaceAll(".pack.gz", ""));
                continue;
            }
            if (filename.endsWith(".pack")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + filename.replace(".pack", "");
                this.debug_sleep(1000L);
                this.extractPack(path + filename, path + filename.replace(".pack", ""));
                continue;
            }
            if (filename.endsWith(".lzma")) {
                this.subtaskMessage = "Extracting: " + filename + " to " + filename.replace(".lzma", "");
                this.debug_sleep(1000L);
                this.extractLZMA(path + filename, path + filename.replace(".lzma", ""));
                continue;
            }
            if (!filename.endsWith(".gz")) continue;
            this.subtaskMessage = "Extracting: " + filename + " to " + filename.replace(".gz", "");
            this.debug_sleep(1000L);
            this.extractGZip(path + filename, path + filename.replace(".gz", ""));
        }
    }

    protected void extractNatives(String path) throws Exception {
        Certificate[] certificate;
        this.setState(5);
        float percentageParts = 20.0f / (float)this.nativeJarCount;
        File nativeFolder = new File(path + "natives");
        if (!nativeFolder.exists()) {
            nativeFolder.mkdir();
        }
        if ((certificate = AppletLoader.class.getProtectionDomain().getCodeSource().getCertificates()) == null) {
            URL location = AppletLoader.class.getProtectionDomain().getCodeSource().getLocation();
            JarURLConnection jurl = (JarURLConnection)new URL("jar:" + location.toString() + "!/org/lwjgl/util/applet/AppletLoader.class").openConnection();
            jurl.setDefaultUseCaches(true);
            certificate = jurl.getCertificates();
        }
        for (int i = this.urlList.length - this.nativeJarCount; i < this.urlList.length; ++i) {
            JarEntry entry;
            if (this.fileSizes[i] == -2) continue;
            String nativeJar = this.getJarName(this.urlList[i]);
            JarFile jarFile = new JarFile(path + nativeJar, true);
            Enumeration<JarEntry> entities = jarFile.entries();
            this.totalSizeExtract = 0;
            int jarNum = i - (this.urlList.length - this.nativeJarCount);
            while (entities.hasMoreElements()) {
                entry = entities.nextElement();
                if (entry.isDirectory() || entry.getName().indexOf(47) != -1) continue;
                this.totalSizeExtract = (int)((long)this.totalSizeExtract + entry.getSize());
            }
            this.currentSizeExtract = 0;
            entities = jarFile.entries();
            while (entities.hasMoreElements()) {
                int bufferSize;
                File f;
                entry = entities.nextElement();
                if (entry.isDirectory() || entry.getName().indexOf(47) != -1 || (f = new File(path + "natives" + File.separator + entry.getName())).exists() && !f.delete()) continue;
                this.debug_sleep(1000L);
                InputStream in = jarFile.getInputStream(jarFile.getEntry(entry.getName()));
                FileOutputStream out = new FileOutputStream(path + "natives" + File.separator + entry.getName());
                byte[] buffer = new byte[65536];
                while ((bufferSize = in.read(buffer, 0, buffer.length)) != -1) {
                    this.debug_sleep(10L);
                    ((OutputStream)out).write(buffer, 0, bufferSize);
                    this.currentSizeExtract += bufferSize;
                    this.percentage = 65 + (int)(percentageParts * ((float)jarNum + (float)this.currentSizeExtract / (float)this.totalSizeExtract));
                    this.subtaskMessage = "Extracting: " + entry.getName() + " " + this.currentSizeExtract * 100 / this.totalSizeExtract + "%";
                }
                AppletLoader.validateCertificateChain(certificate, entry.getCertificates());
                in.close();
                ((OutputStream)out).close();
            }
            this.subtaskMessage = "";
            jarFile.close();
            File f = new File(path + nativeJar);
            f.delete();
        }
    }

    protected static void validateCertificateChain(Certificate[] ownCerts, Certificate[] native_certs) throws Exception {
        if (native_certs == null) {
            throw new Exception("Unable to validate certificate chain. Native entry did not have a certificate chain at all");
        }
        if (ownCerts.length != native_certs.length) {
            throw new Exception("Unable to validate certificate chain. Chain differs in length [" + ownCerts.length + " vs " + native_certs.length + "]");
        }
        for (int i = 0; i < ownCerts.length; ++i) {
            if (ownCerts[i].equals(native_certs[i])) continue;
            throw new Exception("Certificate mismatch: " + ownCerts[i] + " != " + native_certs[i]);
        }
    }

    protected Image getImage(String s) {
        Image image = null;
        try {
            image = this.getImage(new URL(this.getCodeBase(), s));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (image == null) {
            image = this.getImage(Thread.currentThread().getContextClassLoader().getResource(s));
        }
        if (image != null) {
            return image;
        }
        this.fatalErrorOccured("Unable to load logo and progressbar images", null);
        return null;
    }

    @Override
    public Image getImage(URL url) {
        try {
            Image image = super.getImage(url);
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(image, 0);
            tracker.waitForAll();
            if (!tracker.isErrorAny()) {
                return image;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected String getJarName(URL url) {
        String fileName = url.getFile();
        if (fileName.endsWith(".pack.lzma")) {
            fileName = fileName.replaceAll(".pack.lzma", "");
        } else if (fileName.endsWith(".pack.gz")) {
            fileName = fileName.replaceAll(".pack.gz", "");
        } else if (fileName.endsWith(".pack")) {
            fileName = fileName.replaceAll(".pack", "");
        } else if (fileName.endsWith(".lzma")) {
            fileName = fileName.replaceAll(".lzma", "");
        } else if (fileName.endsWith(".gz")) {
            fileName = fileName.replaceAll(".gz", "");
        }
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    protected String getFileName(URL url) {
        String fileName = url.getFile();
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    protected Color getColor(String param, Color defaultColor) {
        String color = this.getParameter(param);
        if (color == null) {
            return defaultColor;
        }
        if (color.indexOf(",") != -1) {
            StringTokenizer st = new StringTokenizer(color, ",");
            try {
                return new Color(Integer.parseInt(st.nextToken().trim()), Integer.parseInt(st.nextToken().trim()), Integer.parseInt(st.nextToken().trim()));
            }
            catch (Exception e) {
                return defaultColor;
            }
        }
        try {
            return Color.decode(color);
        }
        catch (NumberFormatException e) {
            try {
                return (Color)Color.class.getField(color).get(null);
            }
            catch (Exception e2) {
                return defaultColor;
            }
        }
    }

    protected boolean getBooleanParameter(String name, boolean defaultValue) {
        String parameter = this.getParameter(name);
        if (parameter != null) {
            return Boolean.parseBoolean(parameter);
        }
        return defaultValue;
    }

    protected void fatalErrorOccured(String error, Exception e) {
        this.fatalError = true;
        this.genericErrorMessage[this.genericErrorMessage.length - 1] = error;
        System.out.println(error);
        if (e != null) {
            System.out.println(e.getMessage());
            System.out.println(AppletLoader.generateStacktrace(e));
        }
        this.repaint();
    }

    protected void setState(int state) {
        this.state = state;
        if (this.debugMode) {
            System.out.println(this.getDescriptionForState());
        }
    }

    protected void debug_sleep(long ms) {
        if (this.debugMode) {
            this.sleep(ms);
        }
    }

    protected void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

